#ifndef _IP_SCFW_H
#define _IP_SCFW_H

#ifdef __KERNEL__
#include <linux/config.h>
#include <linux/version.h>
/* ho==half opened. */
#define SC_FW_MAX_TCP_HASH_TABLE_SIZE		128

#define SC_FW_MAX_HO_HOSTCNT_HASH_TABLE_SIZE	16
#define SC_FW_MAX_HO_PORTCNT_HASH_TABLE_SIZE	16

#define FIELD_HOST	0
#define FIELD_PORT	1
#define SERVER2CLIENT	1
#define CLIENT2SERVER	0

#define SCFW_SOCKHASH_LOCK(lock)	atomic_inc(&(lock))
#define SCFW_SOCKHASH_UNLOCK(lock)	atomic_dec(&(lock))
#define SCFW_SOCKHASH_LOCKED(lock)	atomic_read(&(lock))

struct relay_sock;
struct relay_sock_timer {
	unsigned long	period;
	unsigned long	last;
	struct relay_sock *next;
	struct relay_sock *prev;
};
struct relay_tcp_opt {
/*** These are used in TCP_ESTABLISHED state. ***/
	__u32 disc_seq;		/* Last disconnect pkt(fin or rst)seq. */
	__u32 disc_ack;		/* Last disconnect pkt ack. */
	unsigned long disc_time;	/* The time of the arriving of "disconnect" packet. */
	int disc_dir;		/* The direction of the arriving of "disconnect" packet. */
//	int disc_type;		/* The type(fin or rst) of the arriving of "disconnect" packet. */
	__u32 seq;		/* The difference bewteen cseq&sseq. df1 */
	__u32 ack;		/* The difference bewteen cack&sack. df2 */

/*** These are used in TCP_SYN_SENT state. ***/
	int count;	/* counts the number of retransmits.It's a decending counter,
				from the largest value to zero. */

//	__u32	snd_wnd;	/* The window we expect to receive	*/
	__u16	mss_clamp;	/* Maximal mss, negotiated at connection setup */
 	__u32	rcv_wnd;	/* Current receiver window		*/
 /*
 *      Options received (usually on last packet, some only on SYN packets).
 */
	__u8	rcv_wscale;	/* Window scaling to send to receiver	*/
	__u32	window_clamp;	/* XXX Document this... -DaveM		*/
	__u32	ts_recent;	/* Time stamp to echo next		*/
};
#define TCP_ESTABLISHED_NONE		0
#define TCP_ESTABLISHED_FIN_RECV	1
#define TCP_ESTABLISHED_RST_RECV	2
/* This is a new state we used locally. */
#define TCP_SYN_REQ		(TCP_MAX_STATES + 9)
struct relay_sock {
	__u32 caddr;	/* The foreign address.(c)lient. */
	__u32 saddr;	/* The protected server address.(s)erver. */
	__u16 cport;	/* The foreign port.(c)lient. */
	__u16 sport;	/* The protected server port.(s)erver */
	int direction;
	int field;
	struct dst_entry *dst;	/* rtable used in connect to server.When the connection
							established,we release it. */
	struct sk_buff *skb;
	struct relay_tcp_opt tp;
	struct relay_sock_timer rsktm;
	/* Main hash linkage for various protocol lookup tables. */
	struct relay_sock		*next;
	struct relay_sock		**pprev;

	volatile unsigned char	state;		/* Connection state	*/
	volatile unsigned char	sub_state;		/* Connection sub_state	*/
};
#define df1(rsk)	rsk->tp.seq
#define df2(rsk)	rsk->tp.ack
struct ho_cnt {
	int maxcnt;
	int count;
	__u32 saddr;
	__u16 sport;
	struct ho_cnt		*next;
	struct ho_cnt		**pprev;
};

#define SC_FW_MAX_TM			2
#define SC_FW_TIMER_DISCARD		0
#define SC_FW_TIMER_RETRANSMIT	1
struct sc_fw_timer {
	unsigned long	period;
	unsigned long	last;
/*	atomic_t	count;	The counts for rsks. */
	struct relay_sock *rsks;
	void (*handler)	(struct sc_fw_timer *);
};
#define TCP_SYN_RETRS				3	/* How many retries of the conn_srv_syn. */
#define SC_FW_TCP_DISCARD_TM_PERIOD			(15*HZ)		/* 15 seconds. */
#define SC_FW_TCP_RETRANSMIT_TM_PERIOD		(5*HZ)		/* 5 seconds. */

/* #define SC_FW_TCP_HO_PERIOD		(15*HZ)		The default timeout of ho state. */
#define SC_FW_TCP_CONN_SRV_PERIOD	(5*HZ)		/* The default timeout of conn_srv_syn. */
#define SC_FW_TCP_ESTABLISHED_PERIOD	(15*60*HZ)	/* 15 minutes. */
#define SC_FW_TCP_ESTABLISHED_DISC_PERIOD	(2*60*HZ)	/* 2 minutes. */
#define SC_FW_TCP_ESTABLISHED_DISC_WAIT_PERIOD	(1*60*HZ)	/* 1 minute. */

__inline__ void sc_fw_conn_release(struct relay_sock *rsk);
extern int sc_fw_tcp_conn_request(struct sk_buff *skb);
extern int sc_fw_tcp_client_reset(struct relay_sock *rsk);
extern int sc_fw_tcp_conn_srv_syn(struct relay_sock *rsk);
extern struct relay_sock *sc_fw_new_sock(__u32 saddr,__u32 caddr,__u16 sport, \
					__u16 cport,unsigned short state);

extern void rsks_del(struct sc_fw_timer *tm,struct relay_sock *rsk);
extern void rsks_add(struct sc_fw_timer *tm,struct relay_sock *rsk);
extern void sc_fw_tm_handler(unsigned long data);
extern void sc_fw_tm_discard(struct sc_fw_timer *tm);
extern void sc_fw_tm_retransmit(struct sc_fw_timer *tm);

extern int call_syncookies_fw(struct sk_buff *skb);
extern int ip_scfw_ctl(int optname,char *optval,int optlen);
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)
#include <linux/init.h>
extern int ip_scfw_init(void) __init;
#else /* 2.0.x */
extern int ip_scfw_init(void);
#endif /* 2.1.x */

#endif	/* #ifdef __KERNEL__ */

#ifndef __KERNEL__
typedef unsigned short __u16;
#endif

#define FIELD_HOST	0
#define FIELD_PORT	1
struct sc_fw_rule {
	struct in_addr addr;	/* The protected server address. */
	struct in_addr mask;	/* The addr's mask. */
	__u16 ports[2];			/* From minimal port to maximal port. */
	__u16 invflg;			/* Invert the rule? */
	int field;			/* host count or port count. */
	int maxcnt;			/* Max number of half opened connection. */
	int timeout;		/* Timeout of a half opened connection. */
	struct sc_fw_rule *next;
};
/* The conctrl command insert a rule. */
struct scfw_insert_rule {
	int rulenum;
	struct sc_fw_rule rule;
};
#define SC_FW_INV_ADDR	0x0001
#define SC_FW_INV_PORT	0x0002

#define DEFAULT_MAXCNT	120
#define DEFAULT_TIMEOUT	420

#define IP_SCFW_BASE_CTL 128
#define IP_SCFW_APPEND	(IP_SCFW_BASE_CTL)
#define IP_SCFW_INSERT	(IP_SCFW_BASE_CTL+1)
#define IP_SCFW_DELETE	(IP_SCFW_BASE_CTL+2)
#define IP_SCFW_FLUSH	(IP_SCFW_BASE_CTL+3)

#endif	/* _IP_SCFW_H */
