#!/usr/bin/env python
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

import subprocess
import os
import pylev # levenstein module

class worker:
    def __init__(self, needle, case, repo_path):
        self.goal = needle
        self.case = case
        self.proposals = dict()
        self.git_dir = '--git-dir=' + repo_path #os.path.join(repo_path, '.git')
        #self.worktree = '--work-tree=' + repo_path

    def start(self, gset):
        self.ggsettings = gset
        # rough pattern building: all chars of the word(s) + hotkey sign)
        items = len(self.goal)
        goalpat = ''.join(set(self.goal + self.ggsettings['hotkey']))
        # add +1 for potential hotkey sign
        pattern_counter = '{' + str(items) + ',' + str(items + 1) + '}'
        fullpat = self.ggsettings['pattern_prefix'] + '[' + goalpat + ']' + pattern_counter

        try:
            gg_opt = '-EnI'
            if not self.case: gg_opt += 'i'
            
            gg_matches = subprocess.check_output(
                        ["git", self.git_dir] + #, self.worktree] + 
                            ['grep', gg_opt, fullpat.encode('ascii'), '--'] + 
                            self.ggsettings['file_selectors'], 'HEAD',
                        stderr=subprocess.STDOUT)

        except subprocess.CalledProcessError as e:
            if e.returncode == 1:  # git grep found nothing
                return
            else:
                raise(e)
        except:
            raise
            
        line_matches = gg_matches.splitlines()
        dbg = ""
        for match in line_matches:
            [fname, line, text] = match.split(':', 2)
            goalmatch_real = text.split(self.ggsettings['text_splitter'][0])[1]\
                        .split(self.ggsettings['text_splitter'][1])[0] 
            if self.case: goalmatch = goalmatch_real
            else: goalmatch = goalmatch_real.lower()
            skip = False
            for word in self.goal.split(' '):
                if not self.case: word = word.lower()
                if not word in goalmatch: skip = True
            if skip: continue    

            if goalmatch_real not in self.proposals:
                self.proposals[goalmatch_real] = [[fname, line]]
            else:
                self.proposals[goalmatch_real] += [[fname, line]]
        #~ return str([dbg,gg_matches]+["git", self.git_dir, self.worktree] + 
                                #~ ['grep', gg_opt, fullpat.encode('ascii'), '--'] + 
                                #~ self.gg_selectors);
    
    def apply_lev(self, threshold):
        if self.proposals:
            for value in self.proposals.keys():
                if pylev.levenshtein(value, self.goal) > threshold:
                    del self.proposals[value]
    
class picker:
    def __init__(self, filename, line, repo_path):
        self.filename = os.path.join(repo_path, filename)
        self.line = int(line)
    
    # Get the Resource ID bound to the string :
    # read the lines until the one marked, find the previous curly bracket    
    # get the last word on previous line of bracket
    def get_resid(self):
        with open(self.filename) as fcontent:
            head = [fcontent.next() for x in xrange(self.line)]
        lines = reversed(head)
        if not head:
            return None
        curly = False
        i = 0
        for line in iter(lines):
            if curly:
                return line.strip().split(' ')[-1]
            if '{' in line:
                curly = True
        return None
        
    def get_fname(self):
        return self.filename.split('uiconfig/')[1] 
        
# EOF
