#include <arpa/inet.h>
#include <netdb.h>
#include <cerrno>
#include <iostream>
#include <stdio.h>

#include "calccli.h"

int createCli (char* _hostname, int _port)
{
  int client = ::socket( PF_INET, SOCK_STREAM, 0 );
  std::cout << "connecting to server <" << CALC_HOSTNAME << ":" << CALC_PORT << "> client=" << client << std::endl;

  struct hostent* host_ptr = 0;
  host_ptr = gethostbyname( CALC_HOSTNAME );
  if ( host_ptr == 0 )
	{
	  std::cout << CALC_HOSTNAME << "address not found.." << std::endl;
	  return 0;
	}
  struct in_addr** paddr = ( struct in_addr ** ) host_ptr->h_addr_list;
  char* hostname = inet_ntoa( **paddr );

  sockaddr_in addr;
  addr.sin_family = PF_INET;
  addr.sin_port = htons( CALC_PORT );
  addr.sin_addr.s_addr = inet_addr( hostname );

  int result = connect( client, reinterpret_cast < sockaddr* > ( &addr ),
                        sizeof( addr ) );
  if (result < 0)
	{
	  std::cerr << "connection failed. err=" << errno << std::endl;
	  return 0;
	}
  std::cout << "connected result=" << result << std::endl;
  return client;
}

int main(int argc, char** args)
{
  int client = createCli ((char*)CALC_HOSTNAME, CALC_PORT);
  if (client > 0)
	{
	  RowCol rc = { 200 , 300 };
	  int ret = write (client, &rc, sizeof(rc));
	  printf( "write=%d\n", ret);
	  int value;
	  for (int jj=0; jj < rc.rows_; ++jj)
		{
		  for (int kk=0; kk < rc.cols_; ++kk)
			{
			  value = jj + kk + 2;
			  ret = write (client, &value, sizeof(value));
			  if (ret <= 0)
				{
				  printf( "write failed. jj=%d, kk=%d\n", jj, kk);
				  return -2;
				}
			} // end for each col
		}		  // end for each row
	  printf( "written\n");
	}
  else
	{
	  printf( "connect failed\n");
	}

  return 0;
}

