/*	Serhat Sevki Dincer, jfcgaussATgmail, 12apr2006
	Random Number Generation Add-In for OpenOffice.org Calc

	This program can be used, modified and/or (re)distributed under
	the terms of LGPL. See www.gnu.org for info about LGPL.

	This program has NO warranty.
	OpenOffice.org SDK has been used while writing this program.
*/

#include <stdio.h>
#include <cmath>

#include <cppuhelper/implbase4.hxx> //4-parameter template will be used
#include <cppuhelper/implementationentry.hxx>

#include <com/sun/star/sheet/XAddIn.hpp>
#include <com/sun/star/lang/XServiceName.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>

#include <org/openoffice/sheet/addin/XCalcAddinSock.hpp>

#include "CalcAddinSpread.hpp"


namespace _CalcAddinThr_impl_
{

	class CalcAddinThr_impl : public ::cppu::WeakImplHelper4< ::org::openoffice::sheet::addin::XCalcAddinSock,
		sheet::XAddIn, lang::XServiceName, lang::XServiceInfo > //4-parameter template
	{
	//Locale
		lang::Locale locale;

	public:
	  CalcAddinThr_impl (Reference< XComponentContext > const & xContext) :
		spreadWrap_ (xContext)
	  {
	  }

	//XCalcAddinThr
	  double	SAL_CALL expo( double m ) throw (RuntimeException); //expo(mean)
	  OUString  SAL_CALL methodOne( OUString const & str ) throw (RuntimeException);
	  OUString 	SAL_CALL startThr( ) throw (RuntimeException);
	  OUString	SAL_CALL stopThr( ) throw (RuntimeException);
	  sal_Int32 SAL_CALL methodThree(const Sequence< Sequence< sal_Int32 > > &aValList ) throw (RuntimeException);
	  Sequence< Sequence< sal_Int32 > > 
	            SAL_CALL methodFour( const Sequence< Sequence< sal_Int32 > > &aValList ) throw (RuntimeException);

	//XAddIn
		OUString SAL_CALL getProgrammaticFuntionName( const OUString& aDisplayName ) throw (RuntimeException);
		OUString SAL_CALL getDisplayFunctionName( const OUString& aProgrammaticName ) throw (RuntimeException);
		OUString SAL_CALL getFunctionDescription( const OUString& aProgrammaticName ) throw (RuntimeException);
		OUString SAL_CALL getDisplayArgumentName( const OUString& aProgrammaticName, ::sal_Int32 nArgument ) throw (RuntimeException);
		OUString SAL_CALL getArgumentDescription( const OUString& aProgrammaticName, ::sal_Int32 nArgument ) throw (RuntimeException);
		OUString SAL_CALL getProgrammaticCategoryName( const OUString& aProgrammaticName ) throw (RuntimeException);
		OUString SAL_CALL getDisplayCategoryName( const OUString& aProgrammaticName ) throw (RuntimeException);

	//XServiceName
		OUString SAL_CALL getServiceName(  ) throw (RuntimeException);

	//XServiceInfo
		OUString SAL_CALL getImplementationName(  ) throw (RuntimeException);
		::sal_Bool SAL_CALL supportsService( const OUString& ServiceName ) throw (RuntimeException);
		Sequence< OUString > SAL_CALL getSupportedServiceNames(  ) throw (RuntimeException);

	//XLocalizable
		void SAL_CALL setLocale( const lang::Locale& eLocale ) throw (RuntimeException);
		lang::Locale SAL_CALL getLocale(  ) throw (RuntimeException);

		short  SAL_CALL getFunctionID( const OUString& aDisplayName );

	  CalcAddinSpread	spreadWrap_;
	};							// end class CalcAddinThr_impl

//XCalcAddinThr
	//expo(mean)
	double CalcAddinThr_impl::expo( double m ) throw (RuntimeException)
	{
	  return -m * log( (double)(1+(unsigned int)rand()) / (2+(unsigned int)RAND_MAX) );
	}
  OUString CalcAddinThr_impl::methodOne( OUString const & str )
    throw (RuntimeException)
  {
    return OUString(RTL_CONSTASCII_USTRINGPARAM("called methodOne() of MyService2 implementation: ") ) + str;
  }
 
  OUString CalcAddinThr_impl::startThr( )    throw (RuntimeException)
  {
	spreadWrap_.getDoc();
	spreadWrap_.startThr();
	
    return OUString( RTL_CONSTASCII_USTRINGPARAM("called startThr: ") );
  }

  OUString CalcAddinThr_impl::stopThr () throw (RuntimeException)
  {
	spreadWrap_.stopThr();
    return OUString( RTL_CONSTASCII_USTRINGPARAM("called stopThr: ") );
  }
 
 
  sal_Int32 CalcAddinThr_impl::methodThree(const Sequence< Sequence< sal_Int32 > > &aValList )
    throw (RuntimeException)
  {
  	sal_Int32		n1, n2;
  	sal_Int32		nE1 = aValList.getLength();
  	sal_Int32		nE2;
  	sal_Int32 temp=0;
  	for( n1 = 0 ; n1 < nE1 ; n1++ )
  	  {
  		const Sequence< sal_Int32 >	rList = aValList[ n1 ];
  		nE2 = rList.getLength();
  		const sal_Int32*	pList = rList.getConstArray();
  		for( n2 = 0 ; n2 < nE2 ; n2++ )
  		  {
  			temp += pList[ n2 ];
  		  }
  	  }
  	return temp;
  }
  //It's a matrix operation  should be called like : {=METHODFOUR(A1:B4)}
  Sequence< Sequence< sal_Int32 > > CalcAddinThr_impl::methodFour(const Sequence< Sequence< sal_Int32 > > &aValList )throw (RuntimeException)
  {
  	sal_Int32		n1, n2;
  	sal_Int32		nE1 = aValList.getLength();
  	sal_Int32		nE2;
  	Sequence< Sequence< sal_Int32 > > temp = aValList;
  	for( n1 = 0 ; n1 < nE1 ; n1++ )
  	  {
  		Sequence< sal_Int32 >	rList = temp[ n1 ];
  		nE2 = rList.getLength();
  		for( n2 = 0 ; n2 < nE2 ; n2++ )
  		  {
  			rList[ n2 ] += 4;
  		  }
  		temp[n1]=rList;
  	  }
  	return temp;
  }

	#define _serviceName_ "org.openoffice.sheet.addin.CalcAddinSock"

	static const sal_Char *_serviceName = _serviceName_;
    static const int	   _numFunc = 6;
    static const sal_Char*  _functionName[] = { "EXPO", "methodOne", "startThr", "stopThr", "methodThree", "methodFour"};
    static const sal_Char* _functionDisplayName[] = {"expo", "methodOne", "startThr", "stopThr", "methodThree", "methodFour"};
    static const sal_Char* _functionDescription[] = {"random number", "One", "startThr", "stopThr", "Three", "Four"};
    static const sal_Char* _functionArgument[] = {"m", "none", "none", "none", "cells", "seq cells"};

//XAddIn
	OUString CalcAddinThr_impl::getProgrammaticFuntionName( const OUString& aDisplayName ) throw (RuntimeException)
	{
	  short index = getFunctionID(aDisplayName);
	  if (index >= _numFunc) 	  return OUString(RTL_CONSTASCII_USTRINGPARAM("ERR1"));

	  return OUString::createFromAscii(_functionName[index]);
	}

	OUString CalcAddinThr_impl::getDisplayFunctionName( const OUString& aProgrammaticName ) throw (RuntimeException)
	{
	  short index = getFunctionID(aProgrammaticName);
	  if (index >= _numFunc) 	  return OUString(RTL_CONSTASCII_USTRINGPARAM("ERR2"));

	  return OUString::createFromAscii(_functionDisplayName[index]);
	}

	OUString CalcAddinThr_impl::getFunctionDescription( const OUString& aProgrammaticName ) throw (RuntimeException)
	{
	  short index = getFunctionID(aProgrammaticName);
	  if (index >= _numFunc) 	  return OUString(RTL_CONSTASCII_USTRINGPARAM("ERR3"));

	  return OUString::createFromAscii(_functionDescription[index]);
	}

	OUString CalcAddinThr_impl::getDisplayArgumentName( const OUString& aProgrammaticName, ::sal_Int32 nArgument ) throw (RuntimeException)
	{
	  short index = getFunctionID(aProgrammaticName);
	  if (index >= _numFunc) 	  return OUString(RTL_CONSTASCII_USTRINGPARAM("ERR4"));

	  return OUString::createFromAscii(_functionArgument[index]);
	}

	OUString CalcAddinThr_impl::getArgumentDescription( const OUString& aProgrammaticName, ::sal_Int32 nArgument ) throw (RuntimeException)
	{
	  short index = getFunctionID(aProgrammaticName);
	  if (index >= _numFunc) 	  return OUString(RTL_CONSTASCII_USTRINGPARAM("ERR5"));

	  return OUString::createFromAscii(_functionArgument[index]);
	}

	OUString CalcAddinThr_impl::getProgrammaticCategoryName( const OUString& aProgrammaticName ) throw (RuntimeException)
	{
		return OUString(RTL_CONSTASCII_USTRINGPARAM("Add-In"));
	}

	OUString CalcAddinThr_impl::getDisplayCategoryName( const OUString& aProgrammaticName ) throw (RuntimeException)
	{
		return OUString(RTL_CONSTASCII_USTRINGPARAM("Add-In"));
	}

//XServiceName
	OUString CalcAddinThr_impl::getServiceName(  ) throw (RuntimeException)
	{
		return OUString(_serviceName, sizeof(_serviceName_)-1, RTL_TEXTENCODING_ASCII_US);
	}

//XServiceInfo
	static OUString getImplementationName_CalcAddinThr_impl() throw (RuntimeException)
	{
		return OUString(RTL_CONSTASCII_USTRINGPARAM("org.openoffice.sheet.addin.CalcAddinThr_impl.CalcAddinSock"));
	}

	OUString CalcAddinThr_impl::getImplementationName() throw (RuntimeException)
	{
		return getImplementationName_CalcAddinThr_impl();
	}

	::sal_Bool CalcAddinThr_impl::supportsService( OUString const & serviceName ) throw (RuntimeException)
	{
		return serviceName.equalsAsciiL(_serviceName, sizeof(_serviceName_)-1);
	}

	static Sequence< OUString > getSupportedServiceNames_CalcAddinThr_impl() throw (RuntimeException)
	{
		Sequence< OUString > name(1);
		name[0] = OUString(_serviceName, sizeof(_serviceName_)-1, RTL_TEXTENCODING_ASCII_US);
		return name;
	}

	Sequence< OUString > CalcAddinThr_impl::getSupportedServiceNames() throw (RuntimeException)
	{
		return getSupportedServiceNames_CalcAddinThr_impl();
	}

//XLocalizable
	void CalcAddinThr_impl::setLocale( const lang::Locale& eLocale ) throw (RuntimeException)
	{
		locale = eLocale;
	}

	lang::Locale CalcAddinThr_impl::getLocale(  ) throw (RuntimeException)
	{
		return locale;
	}

    short CalcAddinThr_impl::getFunctionID (const OUString& stringProgmmaticName)
    {
	  for (int ii=0; ii < _numFunc; ++ii)
		{
		  const sal_Char* name = _functionDisplayName[ii];
		  if(stringProgmmaticName.equalsAscii(name))
			{
			  return (short) ii;
			}
		}
	  return -1;
    }

	static Reference< XInterface > SAL_CALL create_CalcAddinThr_impl( Reference< XComponentContext > const & xContext ) SAL_THROW( () )
	{
	  return static_cast< ::cppu::OWeakObject * > ( new CalcAddinThr_impl (xContext) );
	}

	static struct ::cppu::ImplementationEntry s_component_entries[] =
	{
		{ create_CalcAddinThr_impl, getImplementationName_CalcAddinThr_impl,
			getSupportedServiceNames_CalcAddinThr_impl, ::cppu::createSingleComponentFactory, 0, 0 }
		,
		{ 0, 0, 0, 0, 0, 0 }
	};
}

extern "C"
{
	void SAL_CALL component_getImplementationEnvironment( sal_Char const ** ppEnvTypeName, uno_Environment ** ppEnv )
	{
		*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
	}

	void * SAL_CALL component_getFactory( sal_Char const * implName,
		lang::XMultiServiceFactory * xMgr, registry::XRegistryKey * xRegistry )
	{
		return ::cppu::component_getFactoryHelper(implName, xMgr, xRegistry, ::_CalcAddinThr_impl_::s_component_entries );
	}

} // end namespace  _CalcAddinThr_impl_
