#include <iostream>
#include <stdio.h>
#include <sys/time.h>
#include <cerrno>

#include <osl/thread.h>

#include <com/sun/star/beans/XPropertySet.hpp>
#include <com/sun/star/lang/IndexOutOfBoundsException.hdl>

#include <com/sun/star/sheet/XSpreadsheetView.hpp>
#include <com/sun/star/sheet/XCellRangeData.hpp>

#include <com/sun/star/table/XCell.hpp>
#include <com/sun/star/table/XCellRange.hpp>

#include "calccli.h"
#include "CalcAddinSpread.hpp"

  /// SCalc code ported to C++

namespace _CalcAddinThr_impl_
{
 
void CalcAddinSpread::insertIntoCellS(int CellX, int CellY, OUString theValue, Reference < XSpreadsheet > TT1)
{
  try {
	Reference < XCell > xCell = TT1->getCellByPosition(CellX, CellY);
	xCell->setFormula(theValue);
  } catch (IndexOutOfBoundsException ex) {
	printf("Could not get Cell\n");
  }
}

void CalcAddinSpread::chgbColor ( int x1, int y1, int x2, int y2,OUString tmplate, Reference < XSpreadsheet > TT )
{
  try {
	Reference < XCellRange > xCR = TT->getCellRangeByPosition(x1,y1,x2,y2);
	Reference < XPropertySet > xCPS ( xCR, UNO_QUERY );
	xCPS->setPropertyValue("CellStyle", Any(tmplate));
  } catch (IndexOutOfBoundsException ex) {
	printf("Could not get CellRange\n");
  } catch (Exception e) {
	printf("Can't change colors chgbColor\n");
  }
}

void CalcAddinSpread::createHeader ( )
{
  printf("Creating the Header\n");

  insertIntoCellS(1,0,"JAN",sheet_);
  insertIntoCellS(2,0,"FEB",sheet_);
  insertIntoCellS(3,0,"MAR",sheet_);
  insertIntoCellS(4,0,"APR",sheet_);
  insertIntoCellS(5,0,"MAI",sheet_);
  insertIntoCellS(6,0,"JUN",sheet_);
  insertIntoCellS(7,0,"JUL",sheet_);
  insertIntoCellS(8,0,"AUG",sheet_);
  insertIntoCellS(9,0,"SEP",sheet_);
  insertIntoCellS(10,0,"OCT",sheet_);
  insertIntoCellS(11,0,"NOV",sheet_);
  insertIntoCellS(12,0,"DEC",sheet_);
  insertIntoCellS(13,0,"SUM",sheet_);
}

void CalcAddinSpread::fillLines ( )
{
  printf("Fill the lines\n");

  RowCol rc;
  // get the number of rows and cols from socket
  int ret = read(server_, &rc, sizeof(rc));
  printf("read=%d,rows=%d,cols=%d\n", ret, rc.rows_, rc.cols_);
  if ((rc.rows_ <= 0) || (rc.cols_ <=0)) return;

  printf("Getting spreadsheet\n");

  struct timeval beg, end;
  gettimeofday(&beg, NULL);
  Reference < XCell > xCell;
  xModel_->lockControllers();
		
  Reference< XCellRange > 			xCellRange1( sheet_, UNO_QUERY );
  Reference< XCellRange > 			xCellRange = xCellRange1->getCellRangeByPosition( 0, 0, rc.cols_, rc.rows_ );
  Reference< XCellRangeData >		xCellRangeData( xCellRange, UNO_QUERY );
  Sequence < Sequence < Any > > 	data = xCellRangeData->getDataArray();

  sal_Int32 value;
  for (int jj=0; jj < rc.rows_; ++jj)
	{
	  for (int kk=0; kk < rc.cols_; ++kk)
		{
		  int ret = read(server_, &value, sizeof(value));
		  data[jj+1][kk+1] <<= value;
		}
	}

  xCellRangeData->setDataArray(data);
  xModel_->unlockControllers();
  gettimeofday(&end, NULL);
  time_t sec  = end.tv_sec - beg.tv_sec;
  time_t usec = end.tv_usec - beg.tv_usec;
  if (usec > 0)
	printf("num cells=[%d], time=[%ds %dus]\n", rc.rows_*rc.cols_, sec, usec);
  else
	printf("num cells=[%d], time=[%ds %dus]\n", rc.rows_*rc.cols_, sec-1, 1-usec);

  //***************************************************************************
}

void CalcAddinSpread::applyStyle ()
{
  // change backcolor
  chgbColor( 1 , 0, 13, 0, "My Style", sheet_ );
  chgbColor( 0 , 1, 0, 3, "My Style", sheet_ );
  chgbColor( 1 , 1, 13, 3, "My Style2", sheet_ );
}

void CalcAddinSpread::startThr ()
{
  // create and start the runThread with 2 as a parameter value
  oslThread hRunThread = osl_createThread(runThread, (void*)this);
  //  osl_suspendThread(hRunThread);
}

void CalcAddinSpread::stopThr ()
{
  stop_ = true;
}

bool CalcAddinSpread::acceptConnection ()
{
  int sockfd = ::socket( PF_INET, SOCK_STREAM, 0 );
  std::cout << "listening on port <" << CALC_PORT << "> sockfd=" << sockfd << std::endl;

  sockaddr_in	address;
  socklen_t		socklen;
  address.sin_family = PF_INET;
  address.sin_port = htons( CALC_PORT );
  address.sin_addr.s_addr = INADDR_ANY;
  socklen = sizeof( address );

  int result = ::bind( sockfd, reinterpret_cast < sockaddr* > ( &address ),
                     socklen );
  if ( result < 0 ) return -1;
  
  //  start listening
  result = ::listen( sockfd, SOMAXCONN );
  if ( result < 0 ) return -1;

  socklen_t len = sizeof( address );
  server_ = ::accept( sockfd, reinterpret_cast < sockaddr* > ( &address ), &len);
  if (server_ < 0)
  	{
  	  std::cerr << "connection failed. err=" << errno << std::endl;
  	  return false;
  	}
  std::cout << "connected server=" << server_ << std::endl;
  return true;
}

void CalcAddinSpread::fincli ()
{
  shutdown(server_, SHUT_RDWR);
}

static void SAL_CALL runThread (void* _pdata)
{
  CalcAddinSpread* calcAddin = (CalcAddinSpread*) _pdata;
  printf("waiting to accept conn\n");
  if (!calcAddin->acceptConnection())
  	{
  	  printf("accept failed\n");
  	  return;
  	}

  try {
	calcAddin->createHeader ();
	calcAddin->applyStyle ();
	while (!calcAddin->stop_)
	  {
		calcAddin->fillLines ();
	  } // end while
  } catch (Exception e) {
	printf("*** Error Couldn't get Sheet\n");
  }		// end try

  calcAddin->fincli();
  printf("finished\n");
}

Reference< XSpreadsheet > CalcAddinSpread::getDoc (void )
{
  if (sheet_ == NULL)
	{
	  Reference< XMultiComponentFactory >	xMCFC(xContext_->getServiceManager());
	  Reference< XInterface >				aDesktop = xMCFC->createInstanceWithContext(OUString( "com.sun.star.frame.Desktop" ), xContext_ );
	  Reference< XDesktop > 				xDesktop( aDesktop, UNO_QUERY );
	  Reference< XComponent >				xCurComp = xDesktop->getCurrentComponent();	

	  Reference< XModel > xModel( xCurComp, UNO_QUERY );
	  Reference< XController > xCtrler = xModel->getCurrentController();
	  Reference< XSpreadsheetView > xView( xCtrler, UNO_QUERY );
	  xModel_  = xModel;
	  sheet_ = xView->getActiveSheet();
	  server_ = 0;
	}
  return sheet_;
}
/// SCalc code ported to C++

} // end namespace  _CalcAddinThr_impl_
