/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* signals.c:
 *	provide clean-up after trapping external signals
 */

#include	<lbl.h>
#include	<signal.h>

extern char	tempname[];

int
onsignal()
{
	unlink(tempname);
	_exit(2);
}

setsignals()
{
	int	(*oldsig)();

	if ((oldsig=signal(SIGINT, onsignal)) == SIG_IGN)
		signal(SIGINT, SIG_IGN);
	if ((oldsig=signal(SIGQUIT, onsignal)) == SIG_IGN)
		signal(SIGQUIT, SIG_IGN);
	if ((oldsig=signal(SIGHUP, onsignal)) == SIG_IGN)
		signal(SIGHUP, SIG_IGN);
	if ((oldsig=signal(SIGTERM, onsignal)) == SIG_IGN)
		signal(SIGTERM, SIG_IGN);
}
