/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* rescan.c:
 *	read temporary file, substituting for defined labels
 */

#include	<lbl.h>
#include	<ctype.h>

extern char	delimiter;
extern char	*filename;
extern FILE	*tempfile;
extern long	fileline;

int	translate = 1;

rescan()
{
	rg int	c;
		/* Keep tempfile, delimiter and translate flag in registers to
		 * speed up this routine; the last two need to be reloaded after
		 * and only after calls to domagic()
		 */
	rg FILE *tf = tempfile;
	rg int	dlm = delimiter;
	rg int	tr = translate;

	while ((c = getc(tf)) != EOF)
	{
		if (c == MAGIC1)
		{
			if ((c = getc(tf)) == MAGIC2)
			{
				domagic();
				dlm = delimiter;
				tr = translate;
				continue;
			}
			else
				ungetc(c, tf);
		}
		if (c == dlm && tr)
		{
			doreplace();
			continue;
		}
		if (c == '\n')
			fileline++;
		putchar(c);
	}
}

domagic()
{
	int		c;
	static char	buffer[BUFSIZ];

	switch (getc(tempfile))
	{
		case M_DELIM:
			c = getc(tempfile);
			if (c == '\n')
				translate = 0;
			else
			{
				translate = 1;
				delimiter = c;
				getc(tempfile);
			}
			break;
		case M_FILE:
			fgets(buffer, BUFSIZ, tempfile);
			buffer[strlen(buffer)-1] = '\0';
			filename = buffer;
			fileline = 1;
			break;
	}
}

doreplace()
{
	rg int		c;
	char		typename[BUFSIZ];
	char		labelname[BUFSIZ];
	rg type		*tp;
	rg label	*lp;

	/* <delimiter><delimiter> gives <delimiter> as output */
	if ((c = getc(tempfile)) == delimiter)
	{
		putchar(delimiter);
		return;
	}
	ungetc(c, tempfile);
	getword(typename);
	getword(labelname);
	if ((c = getc(tempfile)) != delimiter)
	{
		error("malformed label reference");
		while (c != delimiter)
		{
			if (c == EOF || c == '\n')
				break;
			c = getc(tempfile);
		}
		return;
	}
	if ((tp = findtype(typename, 0)) == NULL)
	{
		error("undefined type '%s'", typename);
		printf("<<%s %s>>", typename, labelname);
		return;
	}
	if ((lp = findlabel(tp, labelname)) == NULL)
	{
		error("undefined label '%s'", labelname);
		printf("<<%s %s>>", typename, labelname);
		return;
	}
	printl(lp, stdout);
}

getword(buffer)
	rg char	*buffer;
{
	rg int	c;
	rg int	dlm = delimiter;
	rg FILE *tf = tempfile;

	c = getc(tf);
	while (isspace(c))
		c = getc(tf);
	while (c != dlm && !isspace(c) && c != '\n' && c != EOF)
	{
		*buffer++ = c;
		c = getc(tf);
	}
	*buffer = '\0';
	if (!isspace(c) && c != EOF)
		ungetc(c, tf);
}
