/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* list.c:
 *	list definitions in verbose mode
 */

#include	<lbl.h>

extern char	*def_format;
extern type	*typetable;

listdefs()
{
	type	*tp;

	if (typetable == NULL)
	{
		fprintf(stderr, "No labels defined\n");
		return;
	}
	for (tp = typetable; tp != NULL; tp = tp->t_next)
		listtype(tp);
}

listtype(tp)
	type	*tp;
{
	label	*lp;

	fprintf(stderr, "*** Type %s: format %s\n", tp->t_name,
		tp->t_format==def_format ? "default" : tp->t_format);
	if (tp->t_labels == NULL)
	{
		fprintf(stderr, "(No labels defined\n)");
		return;
	}
	for (lp = tp->t_labels; lp != NULL; lp = lp->l_next)
	{
		fprintf(stderr, "%-16.16s %-14.14s %-6D ",
				lp->l_name,
				lp->l_file,
				lp->l_line);
		printl(lp, stderr);
		putc('\n', stderr);
	}
	putc('\n', stderr);
}
