/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* lbl.c:
 *	main program - decode switches and arguments
 *	and process each input file.
 * usage:
 *	lbl [ -d<char> ] [ -m<macro> ] [ -l ] [ -s ]
 *		-d	<char> delimits in-line occurrences of a tag
 *		-m	<macro> defines a tag value
 *		-l	list label definitions
 *		-s	suppress nroff output (implies -l)
 * defaults:
 *	-d@ -mL=
 */

#include	<lbl.h>

extern int	lflag;
extern int	sflag;
extern char	delimiter;
extern char	macroname[];
extern char	tempname[];
extern char	*progname;
extern FILE	*tempfile;

main(argc, argv)
	us int	argc;
	char	*argv[];
{
	us int		decode();
	us int		nflags;
	FILE		*input;
	int		anydone		= 0;
	static char	standard[]	= "standard input";

	if (argc != 0)
	{
		argc--;
		progname = *(argv++);
	}
	nflags = decode(argc, argv);
	argc -= nflags;
	argv += nflags;

	/* Remaining arguments must be filenames; treat "-"
	 * specially as standard input.
	 * If no arguments, use atandard input.
	 */

	/* Pass 1: copy to temp file, building table of tags */
	if (!sflag)
	{
		mktemp(tempname);
		if ((tempfile=fopen(tempname, "w"))==NULL)
			fatal("cannot make temporary file");
		setsignals();
	}
	if (argc == 0)
	{
		scan(standard, stdin);
		anydone = 1;
	}
	else
	{
		while (argc != 0)
		{
			if (strcmp(argv[0], "-") == 0)
			{
				anydone = 1;
				scan(standard, stdin);
			}
			else
			{
				if ((input=fopen(argv[0], "r")) == NULL)
					error("cannot open %s", argv[0]);
				else
				{
					anydone = 1;
					scan(argv[0], input);
					fclose(input);
				}
			}
			argc--;
			argv++;
		}
	}
	if (!sflag)
		fclose(tempfile);
	if (lflag)
		listdefs();

	/* Pass 2: translate tags */

	if (!anydone)
	{
		unlink(tempname);
		exit(3);
	}
	if (!sflag)
	{
		if ((tempfile=fopen(tempname, "r")) == NULL)
			fatal("temporary file vanished before rescan!");
		rescan();
		unlink(tempname);
	}
	exit(0);
}

/* Decode argument list */
us int
decode(argc, argv)
	us int	argc;
	char	*argv[];
{
	int	nflags = 0;

	while (argc != 0)
	{
		if (argv[0][0] != '-')
			return nflags;
		switch (argv[0][1])
		{
			case 'd':
				if ((delimiter=argv[0][2]) == '\0')
					fatal("missing delimiter after -d");
				if (argv[0][3] != '\0')
					fatal("delimiter must be 1 character");
				break;
			case 'm':
				if ((macroname[0]=argv[0][2]) == '\0' ||
				    (macroname[1]=argv[0][3]) == '\0' ||
				    argv[0][4] != '\0')
					fatal(
					    "macro name must be 2 characters");
				break;
			case 'l':
				lflag = 1;
				break;
			case 's':
				lflag = sflag = 1;
				break;
			default:
				fatal("unknown flag '%s'", argv[0]);
				/*NOTREACHED*/
		}
		argc--;
		argv++;
		nflags++;
	}
	return nflags;
}
