/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* keyword.c:
 *	look up a command keyword (by sequential search).
 */

#include	<lbl.h>

extern int	a_delimiter();
extern int	a_format();
extern int	a_last();

keyword keytable[] =
{
	{ "delimiter",	a_delimiter,	2,	2  },
	{ "format",	a_format,	3,	3  },
	{ "last",	a_last,		3,	22 }
};
#define NKEYS	(sizeof(keytable) / sizeof(keyword))

keyword *
findkeyword(word)
	char	*word;
{
	int	indx;

	for (indx=0; indx < NKEYS; indx++)
		if (strcmp(word, keytable[indx].k_name) == 0)
			return keytable+indx;
	return NULL;
}
