/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* find.c:
 *	routines to find a type entry and a label entry
 */

#include	<lbl.h>

extern type	*typetable;

type *
findtype(name, create)
	rg char	*name;
	rg int	create;
{
	rg type	*tp;

	for (tp = typetable; tp != NULL; tp = tp->t_next)
		if (strcmp(name, tp->t_name) == 0)
			return tp;
	if (create)
		return addtype(name);
	return NULL;
}

label *
findlabel(tp, name)
	rg type		*tp;
	rg char		*name;
{
	rg label	*lp;

	if (tp == NULL)
		return NULL;
	for (lp = tp->t_labels; lp != NULL; lp = lp->l_next)
		if (strcmp(name, lp->l_name) == 0)
			return lp;
	return NULL;
}
