/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* error.c:
 *	report and handle errors
 */

#include	<lbl.h>

extern char	*progname;
extern char	*filename;
extern char	tempname[];
extern long	fileline;

/*VARARGS1*/
error(msg, arg1)
	char	*msg;
	char	*arg1;
{
	fprintf(stderr, "%s: ", progname);
	if (filename != NULL)
		fprintf(stderr, "%s, line %D - ", filename, fileline);
	fprintf(stderr, msg, arg1);
	fprintf(stderr, "\n");
}

/*VARARGS1*/
fatal(msg, arg1)
	char	*msg;
	char	*arg1;
{
	error(msg, arg1);
	unlink(tempname);
	exit(1);
}
