/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* build.c:
 *	routines to build new labels and label-types
 */

#include	<lbl.h>
#include	<ctype.h>

extern char	*def_format;
extern char	*filename;
extern long	fileline;
extern type	*typetable;

char *alloc(nbytes)
	us int	nbytes;
{
	char	*malloc();
	char	*ptr = malloc(nbytes);

	if (ptr==NULL)
		fatal("ran out of memory space");
	return ptr;
}

char *
copy(str)
	char	*str;
{
	char	*strcpy();
	us int	strlen();

	char	*s = alloc(strlen(str)+1);

	return strcpy(s, str);
}

addlbl(lbltype, lbllevel, lblname)
	char	*lbltype;
	char	*lbllevel;
	char	*lblname;
{
	type	*tp = findtype(lbltype, 1);
	label	*lp;
	label	*last;
	us int	bottom;
	us int	indx;

	if (!isdigit(lbllevel[0]))
	{
		error("non-numeric index level");
		return;
	}
	if ((bottom = atoi(lbllevel)) == 0 || bottom > NLEVELS)
	{
		error("index level must be in range 1-%u", NLEVELS);
		return;
	}
	bottom--;

	++(tp->t_levels[bottom]);
	for (indx = bottom+1; indx < NLEVELS; indx++)
		tp->t_levels[indx] = 0;

	if (strcmp(lblname, "*") != 0)
	{
		lp = findlabel(tp, lblname);

		if (lp != NULL)
		{
			error("redefinition of %s ignored", lblname);
			return;
		}
		lp = (label *) alloc(sizeof(label));

		lp->l_name = copy(lblname);
		lp->l_type = tp;
		for (indx = 0; indx < bottom; indx++)
			lp->l_levels[indx] = tp->t_levels[indx];
		lp->l_levels[bottom] = tp->t_levels[bottom];
		lp->l_bottom = bottom;
		lp->l_file = filename;
		lp->l_line = fileline;
		lp->l_next = NULL;
		/* Add to end of list, so that verbose listing comes out
		 * in order
		 */
		if (tp->t_labels == NULL)
			tp->t_labels = lp;
		else
		{
			for (last = tp->t_labels; last->l_next != NULL;
							last = last->l_next)
				;
			last->l_next = lp;
		}
	}
}

type *
addtype(name)
	char	*name;
{
	type		*tp = (type *) alloc(sizeof(type));
	us int		indx;

	tp->t_name = copy(name);
	for (indx = 0; indx < NLEVELS; indx++)
		tp->t_levels[indx] = 0;
	tp->t_format = def_format;
	tp->t_labels = NULL;
	tp->t_next = typetable;
	typetable = tp;
	return tp;
}
