/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

/* actions.c:
 *	keyword action routines
 */

#include	<lbl.h>
#include	<ctype.h>

extern char	*def_format;
extern int	sflag;
extern FILE	*tempfile;

/*ARGSUSED*/
a_delimiter(nargs, argvec)
	int	nargs;
	char	*argvec[];
{
	if (strcmp(argvec[1], "off") == 0)
	{
		if (!sflag)
			fprintf(tempfile, "%c%c%c\n", MAGIC1, MAGIC2, M_DELIM);
		return;
	}
	if (argvec[1][1] != '\0')
	{
		error("delimiter more than 1 character");
		return;
	}
	if (argvec[1][0] == '\0')
	{
		error("null delimiter character");
		return;
	}
	if (!sflag)
		fprintf(tempfile, "%c%c%c%c\n", MAGIC1, MAGIC2,
				M_DELIM, argvec[1][0]);
}

/*ARGSUSED*/
a_format(nargs, argvec)
	int	nargs;
	char	*argvec[];
{
	type	*tp	= findtype(argvec[1], 1);

	if (tp->t_format != def_format)
		error("[warning] format for %s redefined", tp->t_name);
	tp->t_format = copy(argvec[2]);
}

/*ARGSUSED*/
a_last(nargs, argvec)
	int	nargs;
	char	*argvec[];
{
	type	*tp	= findtype(argvec[1], 1);
	int	indx;

	nargs -= 2;
	argvec += 2;
	for (indx = 0; indx < nargs; indx++)
	{
		if (!isdigit(argvec[indx][0]))
		{
			error("non-numeric label index");
			break;
		}
		tp->t_levels[indx] = atoi(argvec[indx]);
	}
	while (indx < NLEVELS)
		tp->t_levels[indx++] = 0;
}
