/* (C) C.D.F. Miller, Heriot-Watt University, March 1984
 *
 *	Permission is hereby given to reproduce or modify this
 *	software freely, provided that this notice be retained,
 *	and that no use be made of the software for commercial
 *	purposes without the express written permission of the
 *	author.
 */

#define	rg		register
#define	us		unsigned

/*** Header levels ***/
#define	NLEVELS	20
typedef	us int			levels[NLEVELS];

/*** Header format ***/
typedef	char			*format;

/*** Label type: name and current header levels ***/
typedef struct type
{
	char		*t_name;
	levels		t_levels;
	format		t_format;
	struct label	*t_labels;
	struct type	*t_next;
}				type;

/*** Label definition ***/
typedef struct label
{
	char		*l_name;
	type		*l_type;
	levels		l_levels;
	us int		l_bottom;		/* Last significant level */
	char		*l_file;		/* File where defined */
	long		l_line;			/* line   "      "    */
	struct label	*l_next;
}				label;

/*** Action routine ***/
typedef int			(*func)();

/*** Command keyword ***/
typedef struct keyword
{
	char	*k_name;
	func	k_action;
	us int	k_minargs;
	us int	k_maxargs;
}				keyword;
