#  Encapsulated PostScript
#       grops itself doesn't emit bounding box information.  With the  help  of
#       GhostScript the following commands will produce an encapsulated PS file
#       foo.eps from input file foo:

groff -Tps -P-b16 foo > foo.ps
gs -dNOPAUSE -sDEVICE=bbox -- foo.ps 2> foo.bbx
cat foo.ps | sed -e '/^%%Orientation/rfoo.bbx' > foo.eps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pdfwrite -sOutputFile=foo.pdf foo.eps quit.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pngmono -r1200 -sOutputFile=foo.png foo.eps quit.ps
pdfinfo foo.pdf > foo.txt
ps2epsi foo.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pdfwrite -sOutputFile=foo_i.pdf foo.epsi quit.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pngmono -r1200 -sOutputFile=foo_i.png foo.epsi quit.ps
pdfinfo foo_i.pdf > foo_i.txt
#rm foo.bbx
#Let us use a small 2in x 2in page 
groff -Tps -P-b16 -P-p2i,2i foo > foo_small.ps
gs -dNOPAUSE -sDEVICE=bbox -- foo_small.ps 2> foo_small.bbx
cat foo_small.ps | sed -e '/^%%Orientation/rfoo_small.bbx' > foo_small.eps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pdfwrite -sOutputFile=foo_small.pdf foo_small.eps quit.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pngmono -r1200 -sOutputFile=foo_small.png foo_small.eps quit.ps
pdfinfo foo_small.pdf > foo_small.txt
ps2epsi foo_small.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pdfwrite -sOutputFile=foo_small_i.pdf foo_small.epsi quit.ps
gs -dEPSCrop -DNOPAUSE -sDEVICE=pngmono -r1200 -sOutputFile=foo_small_i.png foo_small.epsi quit.ps
pdfinfo foo_small_i.pdf > foo_small_i.txt
#rm foo_small.bbx
