/*
 * Copyright (c) 1999 G. Adam Stanislav
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	fput.utf-8.c v.1
 */

#include <stdio.h>

#define	bits(c)	(0x80 | ((c) & 0x3F))
#define	put(c)	if (fputc((c), output) == EOF) return EOF
#define	putbits(c)	put(bits(c))

int fputu8(unsigned int c, FILE *output) {
	if (output == NULL)
		return EOF;

	if (c < 0x80) {
		put(c);
	}
	else if (c < 0x800) {
		put(0xC0 | (c >>  6));
		putbits(c);
	}
	else if (c < 0x10000) {
		put(0xE0 | (c >> 12));
		putbits(c >>  6);
		putbits(c);
	}
	else if (c < 0x200000) {
		put(0xF0 | (c >> 18));
		putbits(c >> 12);
		putbits(c >>  6);
		putbits(c);
	}
	else if (c < 0x400000) {
		put(0xF8 | (c >> 24));
		putbits(c >> 18);
		putbits(c >> 12);
		putbits(c >>  6);
		putbits(c);
	}
	else if (c < 0x80000000) {
		put(0xFC | (c >> 30));
		putbits(c >> 24);
		putbits(c >> 18);
		putbits(c >> 12);
		putbits(c >>  6);
		putbits(c);
	}
	else	/* Error, cannot convert */
		return 1;

	return 0;
}

