use16

cpu 8086

org 0x100

	MOV		DI, AnsiTestString
PrintLoop:
	MOV  	DL, [DI] 	; Load Character
	INC  	DI				; Increment DI pointer offset
	CMP  	DL, 0			; Test for end of string
	JE   	PrintDone 		; If end of string, jump to check for result
	MOV  	AH, 0x02		; Function - Write Char to StdOut
	INT  	0x21		    ; Send Character to STDOut
	JMP  	PrintLoop		; Print next character
PrintDone:

	MOV  AH, 0x06			; Direct Console I/O
	MOV  DL, 0xFF			; 0xff means get a character
	INT  0x21				; Fetch 1st character
	JZ   BadResponse		; if ZF, no character available
	CMP  AL, 27				; Verify 1st character is ESC
	JNE  BadResponse
	MOV  AH, 0x06
	MOV  DL, 0xFF
	INT  0x21				; Fetch 2nd character
	JZ   BadResponse
	CMP  AL, '['			; Verify 2nd character is left brace
	JNE  BadResponse

IgnoreLoop:					; Ignore all characters upto the letter R
	MOV  AH, 0x06
	MOV  DL, 0xFF
	INT  0x21
	JZ   BadResponse		; Ran out of letters before R was found
	CMP  AL,'R'
	JNE  IgnoreLoop			; Continue ignoring

BadResponse:
	MOV  AH, 0x06
	MOV  DL, 0xFF
	INT  0x21				; Get one more character, that needs to be CR
	JZ   DisplayCleanUp		; Test failed, clean up displayed garbage characters
	CMP  AL,13
	MOV  DX, AnsiGood
	MOV	 AL, 0
	JE   Supported

DisplayCleanUp:
	MOV  DI, AnsiTestString

CleanUpLoop:
	MOV  DL, [DI]
	INC  DI
	CMP  DL, 0
	JE   Unsupported
	MOV  AH, 0x02
	MOV  DL, 8				; backspace
	INT  0x21
	MOV  AH, 0x02			; space
	MOV  DL, 32
	INT  21
	MOV  AH, 0x02
	MOV  DL, 8				; another backspace
	INT  0x21
	JMP  CleanUpLoop

Unsupported:
	MOV  DX, AnsiBad
	MOV	 AL, 1
Supported:
	MOV	 AH, 0x09
	INT	 0x21				; Display Result String
	MOV	 AH, 0x4c
	INT  0x21				; terminate with result code 0/1


AnsiTestString:
	db 	27,'[6n',0
AnsiGood:
	db	'ANSI supported$'
AnsiBad:
	db	'ANSI not supported$'


