/* This program is in the public domain. */
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <pthread.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>

#include <GL/glx.h>

extern int future_hw_tcl_on;
int inited=0;

void *check_magic(void *arg){
	Display *dpy;
	XEvent event;
	
	do{
		dpy=glXGetCurrentDisplay();
		sleep(1);
	}while(dpy==NULL);
	
	fprintf(stderr, "entering loop\n");
	for(;;){ 
		XLockDisplay(dpy);
		if(!XCheckTypedEvent(dpy, KeyPress, &event)) goto out;

		switch(event.type) {
		case KeyPress:
			switch(XLookupKeysym(&event.xkey, 0)){
			case XK_F11:
				future_hw_tcl_on=0;
				fprintf(stderr, "Software tnl\n");
			goto out;

			case XK_F12:
				future_hw_tcl_on=1;
				fprintf(stderr, "Hardware tnl\n");
			goto out;
			
			default: break;
		}
		break;
		default: break;
		}
		XPutBackEvent(dpy, &event);
		
		out:
		XUnlockDisplay(dpy);
		usleep(10);
	}
}

void __attribute__ ((constructor)) my_init(void){
	pthread_t thread;
	if(inited)
		return ;
	
	XInitThreads(); /* Init threads so we can lock display */
	fprintf(stderr, "Initialized Xlib threads support\n");
	
	if(pthread_create(&thread, NULL, check_magic, NULL)!=0){
		fprintf(stderr, "pthread_create failed!\n");
	}
	inited=1;
}
