/*
 * Mesa 3-D graphics library
 * Version:  6.2
 *
 * Copyright (C) 1999-2004  Brian Paul   All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "GL/glut.h"
#include <GL/gl.h>

/**
 * Different kinds of 4x4 transformation matrices.
 * We use these to select specific optimized vertex transformation routines.
 */
enum GLmatrixtype {
   MATRIX_GENERAL,	/**< general 4x4 matrix */
   MATRIX_IDENTITY,	/**< identity matrix */
   MATRIX_3D_NO_ROT,	/**< orthogonal projection and others... */
   MATRIX_PERSPECTIVE,	/**< perspective projection matrix */
   MATRIX_2D,		/**< 2-D transformation */
   MATRIX_2D_NO_ROT,	/**< 2-D scale & translate only */
   MATRIX_3D		/**< 3-D transformation */
} ;

/**
 * Matrix type to represent 4x4 transformation matrices.
 */
typedef struct {
   GLfloat *m;		/**< 16 matrix elements (16-byte aligned) */
   GLfloat *inv;	/**< optional 16-element inverse (16-byte aligned) */
   GLuint flags;        /**< possible values determined by (of \link
                         * MatFlags MAT_FLAG_* flags\endlink)
                         */
   enum GLmatrixtype type;
} GLmatrix;

