
#ifndef __libgl_internals_h_
#define __libgl_internals_h_

#include <stddef.h>

/* Strip these babies down the bare minimum for this example...  Note
 * that these are based on the OpenGL SI rather than Mesa, 'cos that's
 * what I've been working with lately :-)
 */
typedef struct __GLdispatchStateRec {
    void (*Begin)(GLenum);
    void (*End)(void);
    void (*Normal3f)(GLfloat, GLfloat, GLfloat);
    void (*TexCoord2f)(GLfloat, GLfloat);
    void (*Vertex3f)(GLfloat, GLfloat, GLfloat);
} __GLdispatchState;

typedef float __GLfloat;

typedef struct __GLcoordRec {
    __GLfloat x, y, z, w;
} __GLcoord;

typedef struct __GLcolorRec {
    __GLfloat r, g, b, a;
} __GLcolor;

#define __GL_NUM_TEXTURE_UNITS 2

typedef struct __GLcurrentStateRec {
    __GLcolor color;
    __GLcoord normal;
    __GLcoord texture[__GL_NUM_TEXTURE_UNITS];
} __GLcurrentState;

typedef struct __GLattributeRec {
    __GLcurrentState current;
} __GLattribute;

typedef enum __GLbeginModeEnum {
    __GL_NOT_IN_BEGIN = 0,
    __GL_IN_BEGIN = 1,
    __GL_NEED_VALIDATE = 2,
} __GLbeginMode;

typedef struct __GLcontextRec {
    __GLdispatchState *currentDispatchState;
    __GLattribute state;
    __GLbeginMode beginMode;
    GLint error;
} __GLcontext;


/* Thread descriptor access macros.
 */
enum __libgl_tsd_key_t { _LIBGL_TSD_KEY_CONTEXT = 0,
                         _LIBGL_TSD_KEY_DISPATCH,
                         _LIBGL_TSD_KEY_N = 8 };

struct pthread_descr {
    union {
        struct {
            struct pthread_descr *self;
        } data;
        void *__padding[8];
    } p_header;

    void *p_libgl_specific[_LIBGL_TSD_KEY_N];
};

#define THREAD_SELF                                                     \
({                                                                      \
    register struct pthread_descr *__self;                              \
    __asm__ ("movl %%gs:%P1, %0"                                        \
             : "=r" (__self)                                            \
             : "i" (offsetof(struct pthread_descr,                      \
                             p_header.data.self)));                     \
    __self;                                                             \
})

#define THREAD_GETMEM(descr, member)                                    \
({                                                                      \
    __typeof__(descr->member) __value;                                  \
    assert(sizeof(__value) == 4);                                       \
    __asm__ __volatile__ ("movl %%gs:%P1, %0"                           \
                          : "=r" (__value)                              \
                          : "i" (offsetof(struct pthread_descr,         \
                                          member)));                    \
    __value;                                                            \
})

#define THREAD_SETMEM(descr, member, value)                             \
({                                                                      \
    __typeof__(descr->member) __value = (value);                        \
    assert(sizeof(__value) == 4);                                       \
    __asm__ __volatile__ ("movl %0,%%gs:%P1" :                          \
                          : "r" (__value),                              \
                            "i" (offsetof(struct pthread_descr,         \
                                          member)));                    \
})

#define THREAD_SETUP(s) \
    struct pthread_descr *s = THREAD_SELF

/* Helper functions to get and set the current context and current
 * dispatch pointers.
 */
static __inline__ void *
__libgl_get_current_context(void)
{
    THREAD_SETUP(self);
    return THREAD_GETMEM(self, p_libgl_specific[_LIBGL_TSD_KEY_CONTEXT]);
}

static __inline__ void *
__libgl_get_current_dispatch(void)
{
    THREAD_SETUP(self);
    return THREAD_GETMEM(self, p_libgl_specific[_LIBGL_TSD_KEY_DISPATCH]);
}

static __inline__ void
__libgl_set_current_context(void *ptr)
{
    THREAD_SETUP(self);
    THREAD_SETMEM(self, p_libgl_specific[_LIBGL_TSD_KEY_CONTEXT], ptr);
}

static __inline__ void
__libgl_set_current_dispatch(void *ptr)
{
    THREAD_SETUP(self);
    THREAD_SETMEM(self, p_libgl_specific[_LIBGL_TSD_KEY_DISPATCH], ptr);
}

/* The OpenGL SI defines these for convenience, so I will too.
 */
#define __gl_context   ((__GLcontext *) __libgl_get_current_context())
#define __gl_dispatch  (((__GLdispatchState *) __libgl_get_current_dispatch()))

#define __GL_SETUP() \
    __GLcontext *gc = __gl_context

#endif /* __libgl_internals_h_ */
