/*
 *  This file contains a time measurement routine that reads CPU cycles 
 *  from the RDTSC register. It is complementary to the Technical Report
 *  that may be found at http://www.cs.ubc.ca/spider/vk/mmx.html If you 
 *  have any comments or suggestions please e-mail Vladimir Kravtchenko 
 *  at vk@cs.ubc.ca or write to Computer Science Department, University of
 *  British Columbia, 201-2366 Main Mall, Vancouver, BC, V6T 1Z4, Canada.
 *
*/

//#define CPS 166550000
//#define CPS 200000000
//#define CPS 233000000
//#define CPS 266000000
#define CPS 700000000

//#define GETTSC_OVERHEAD 0x7a  // it can be measured by getTSC(start); getTSC(end);
//#define GETTSC_OVERHEAD 0x75  // with nothing in between and nc=TSCdiff(start, end); 
  #define GETTSC_OVERHEAD 0x00  // but in fact, is so small that may be easily ignored

typedef struct { unsigned int high, low; } TSC;

#define getTSC(t) asm volatile("cpuid \n\t rdtsc\n\t movl %%edx, %0\n\t movl %%eax, %1\n\t" : "=m" (t.high), "=m" (t.low))

TSC TSCdiff(TSC t1, TSC t2)
{
  TSC ret_val;

  if (t2.high == t1.high)
     {
       ret_val.high = 0;
       ret_val.low  = t2.low - t1.low;
     }
  else if (t2.low > t1.low)
          {
            ret_val.high = t2.high - t1.high;
            ret_val.low  = t2.low - t1.low;
	  }
       else
	  {
            ret_val.high = t2.high - t1.high -1; 
            ret_val.low  = ~t1.low + t2.low;
          }

  if (ret_val.low >= GETTSC_OVERHEAD)
     {
       ret_val.low -= GETTSC_OVERHEAD;
     }
  else
     {
       ret_val.high--;
       ret_val.low = ~ret_val.low + GETTSC_OVERHEAD;
     }

  return ret_val;
}

float TSCdiff_to_sec(TSC diff)
{
  return (((float) 0xffffffff/CPS)*diff.high + ((float) diff.low)/CPS);
}

void PrintResults(TSC mmx, TSC nor)
{
  float mmxt, nort;

  mmxt = TSCdiff_to_sec(mmx);
  nort = TSCdiff_to_sec(nor);

  printf("CPU:    %i MHz\n", CPS/1000000);
  printf("MMX:    %u %u time: %f sec\n", mmx.high, mmx.low, mmxt);
  printf("Normal: %u %u time: %f sec\n", nor.high, nor.low, nort);
  printf("Factor: %f\n\n", nort/mmxt);
}







