#!/bin/sh


check_ret_val()
{
	error_value="${?}"
	
	if [ ${error_value} != 0 ]; then
		cat .autogen.log
		exit 1
	fi
	
	return 0
}


rm -f config.cache acconfig.h .autogen.log

echo "libtoolize..."
libtoolize --force >.autogen.log 2>&1
check_ret_val

echo "aclocal..."
aclocal >.autogen.log 2>&1
check_ret_val

echo "autoconf..."
autoconf >.autogen.log 2>&1
check_ret_val

echo "autoheader..."
autoheader >.autogen.log 2>&1
check_ret_val

echo "automake..."
automake --add-missing --copy --gnu >.autogen.log 2>&1
check_ret_val

rm -f .autogen.log

exit 0

