#include "Signal.h"

void  signal_free(Signal **signal) {
  int i;
  if(!signal) 
    g_print("[signal_free]Cant free NULL signal array\n");
  for(i = 0; i < SIGNAL_COUNT; i++) {
    if(!signal[i])
      continue;
    if(DEBUG)
      g_print("[signal_free]freeing action\n");
    action_free(signal[i]->action);
    g_free(signal[i]);
  }
}

void show_signal_info(Signal *s) {
  if(!s) {
    if(DEBUG)
      g_print("\tsignal is NULL\n");
    return ;
  }
  g_print("\tEvent name: %s\n", sigflag_to_signame(s->event_type));
  action_print(s->action);
}

void  show_signals_info(Signal **ss) {
  int i;
  if(!ss) {
    g_print("\tno signal\n");
    return;
  }
  for(i = 0;i<SIGNAL_COUNT;i++)
    show_signal_info(ss[i]);
}

const char *sigflag_to_signame(int t) {
  int i;
  for(i = 0; sigs[i].signame; i++)
    if(sigs[i].sigflag == t)
      return sigs[i].signame;
  return "";
}
