#include "Setting.h"
#include "Action.c"
#include "Signal.c"

GKeyFile * settings_init_file(gchar *filename) {
  GError *error = NULL;
  GKeyFile *keyfile = g_key_file_new ();

  if (!g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS, &error)) {
    g_warning ("[settings_init_file]%s",error->message);
    g_error_free(error);
    return NULL;
  }
  return keyfile;
}

DeviceProperties *setting_init_dp(GKeyFile *gkf, gchar *group) {
  DeviceProperties *dp;
  dp = g_new0(DeviceProperties, 1);
  if(collect_props_from_gkfile2(dp,gkf,group))
    return dp;
  return NULL;
}

void settings_init(gchar *filename, Setting **settings, Action **catchall_array){
  gsize length;
  GKeyFile *keyfile = settings_init_file(filename);
  DeviceProperties *dp;
  Action **actions;
  int j = 0, k = 0;
  gchar **groups = g_key_file_get_groups (keyfile, &length);

  while ( *groups != NULL && j < MAX_SETTINGS ) {
    if(settings[j] != NULL) {
      j++;
      if(j >= MAX_SETTINGS) {
        g_warning("[settings_init]Cannot store more settings\n");
        return;
      }
      continue;
    }
    
    dp = setting_init_dp(keyfile, *groups);
    actions = actions_init(keyfile, *groups);
    if(!actions) {
      g_print("TODO\n");
    }
    else if(!dp) {
      for(k = 0; actions[k]; k++) {
	// shouldn't be need
	catchall_array[k] = g_new0(Action, 1);

	catchall_array[k] = actions[k];
      }
    }
    else {
      settings[j] = g_new0(Setting, 1);
      settings[j]->dp = dp;
      g_stpcpy(settings[j]->nickname,*groups);
      // needed ??
      // settings[j]->signal = g_new0(Signal *, SIGNAL_COUNT);
      for(k = 0; actions[k]; k++) {
	settings[j]->signal[k] = g_new0(Signal, 1);
	//old
	// settings[j]->signal[k]->event_name = signalnames[k];
	settings[j]->signal[k]->event_type = sigs[k].sigflag;
	settings[j]->signal[k]->action = actions[k];
      }
    }
    groups++;
  }

}
void settings_init_old(gchar *filename, Setting **settings){
  GKeyFile *keyfile;
  GError *error = NULL;
  gsize length;
  gchar **groups;
  int i = 0, j = 0, k;
  
  keyfile = settings_init_file(filename);
  if(DEBUG)
    g_print("[settings_init_old]opening %s : ok\n",filename);

  groups = g_key_file_get_groups (keyfile, &length);
  while (groups[i] && j<MAX_SETTINGS) {
    if(DEBUG)
      g_print(">[settings_init]loading group [%s]\n",groups[i]);
    
    if(settings[j]) {
      j++;
      if(j >= MAX_SETTINGS) {
	g_warning("Cannot store more settings\n");
	return;
      }
      continue;
    }
    settings[j] = g_new0(Setting, 1);
    settings[j]->dp = g_new0(DeviceProperties, 1);
    g_stpcpy(settings[j]->nickname,groups[i]);
    for( k = 0 ; sigs[k].signame ; k++ ) {
      settings[j]->signal[k] = g_new0(Signal, 1);
      settings[j]->signal[k]->event_type = sigs[k].sigflag;
      // solution 1 but : can't load in a gchar ** !?
      /*settings[j]->signal[k]->to_exec = g_key_file_get_string_list(keyfile, groups[i],  asig, &length, &error);
      g_print("LENGTH = %d !!!!!!!!!!!!!",length);
      if(settings[j]->signal[k]->to_exec == NULL || length == 0) {
	if(DEBUG)
	  g_print("%s\n",error->message);
	settings[j]->signal[k] = NULL;
	}*/

      /** solution 2 */
      settings[j]->signal[k]->action->bin = 
	g_strsplit(
		   g_key_file_get_string(
					 keyfile,
					 groups[i],
					 sigs[k].signame,
					 &error
					 ),
		   " ",
		   MAX_CMDLINE_ARGS);
      if(error) {
	g_print("%s\n",error->message);
	g_error_free(error); error = NULL;
	settings[j]->signal[k] = NULL;
      }
      /* end solution 2 */
    }
      
    if(DEBUG)
      g_print(">[settings_init]collect_props %s: ",filename);
    collect_props_from_gkfile2(settings[j]->dp,keyfile,groups[i]);
    if(DEBUG)
      g_print(">[settings_init]end collect\n");

    if(!settings[j]->nickname) {
      g_warning(">[settings_init]no nickname key found\n");
      i++;
      continue;
    }
    if(!settings[j]->signal) {
      g_warning(">[settings_init]no signal key found\n");
      i++;
      continue;
    }

    /* TO(UN)DO :
       if we get both something to do at plug time AND mount time,
       we skip the plug time event as it will make mount change event
       not being fired
     */
    /*
      Signal *tmpsig;
      
      if((tmpsig = setting_match_on_event(settings[j],DEV_ADDED)) &&
      setting_match_on_event(settings[j], DEV_MOUNTED)) {
      tmpsig = NULL;
      }
    */

    g_print(">[settings_init]loaded [%s]\n",settings[j]->nickname);

    j++;
    i++;
  }
  g_strfreev(groups);
  g_key_file_free(keyfile);

  if (j==1) {
    return ;
    //return NULL;
  }
  // add trailing NULL
  while(j < MAX_SETTINGS)
    settings[j++] = NULL;


  //return settings;
}

      
void setting_free(Setting *s) {
  if(DEBUG) {
    g_print("== Freeing Setting\n");
    g_print("===== Freeing DeviceProperties\n");
  }
  device_properties_free(s->dp);
  if(DEBUG)
    g_print("===== Freeing Signals\n");
  signal_free(s->signal);
  /* g_print("free nick\n");
     g_free(s->nickname);*/
  if(DEBUG)
    g_print("===== Freeing Setting\n");
  g_free(s);
}

void settings_free(Setting **s) {
  int i;
  if(DEBUG)
    g_print("[settings_free]\n");
  for (i=0;i<MAX_SETTINGS;i++)
    if(s[i])
      setting_free(s[i]);
}

void setting_show_info(Setting *a) {
  if(a) {
    g_print("=====SHOW INFO :\n");
    g_print("Setting : %s\n",a->nickname);
    show_signals_info(a->signal);
    do_show_info_device_property(a->dp);
    g_print("================\n");
  } else if(DEBUG)
    g_print("NULL setting\n");
}

void settings_show_info(Setting **a) {
  int i;
  if(a) {
    for(i=0;i<MAX_SETTINGS;i++)
      setting_show_info(a[i]);
  } else
    g_print("NULL settings\n");
  g_print("================\n");
}
// does one of the Setting in settings is triggered by the event evt
gboolean is_one_setting_match_on_event(Setting **a, int evt) {
  if(DEBUG)
    g_print("[is_one_setting_match_on_event] %s\n", sigflag_to_signame(evt));
  Signal *sigtmp;
  int i;
  for(i=0;i<MAX_SETTINGS && a[i];i++) {
    sigtmp=setting_match_on_event(a[i],evt);
    if (sigtmp)
      return TRUE;
  }
  return FALSE;
}

// does the given Setting is triggered by the event evt
// old : Signal *setting_match_on_event(Setting *a, gchar *evt) {
Signal *setting_match_on_event(Setting *a, int evt) {
  int j;
  if(DEBUG)
    g_print("[setting_match_on_event][%s] %s\n", a->nickname, sigflag_to_signame(evt));
  /*
    for( j = 0 ; a->signal[j] ; j++ )
     TODO: forget about merging config file in Setting **
     but stop at the 1st NULL one
  */
  for( j=0 ; j < SIGNAL_COUNT; j++ )
    if(a->signal[j] && a->signal[j]->event_type == evt)
      return a->signal[j];
  return NULL;
}

/* Parse a file in the "Desktop Entry" */
gboolean collect_props_from_gkfile2(DeviceProperties *dp, GKeyFile *gkf, gchar *entry) {
  GError *error = NULL;
  gsize length_collect = 0;
  int i = 0;
  GValue dest_value = {0};
  gboolean handled = FALSE;

  g_type_init ();

  // some defaults:
  /* 1 */
  g_value_init (&dest_value, G_TYPE_BOOLEAN);
  g_value_set_boolean (&dest_value, TRUE);
  collect_props("DeviceIsDrive", &dest_value, dp);
  g_value_unset(&dest_value);
  /* 2 : bugs otherwise */
  dp->device_file_by_id = NULL;
  /* 3 : needs props->drive_media_compatibility != NULL && */
  dp->drive_media_compatibility = NULL;

  // foreach the   "DeviceFile*", "DeviceIs*",  "DeviceMountPaths",  "DeviceSize",  ... id, label , vendor, model
  for (i=0; keynames[i]; i++) {
    //if(!G_IS_VALUE(&dest_value))
    g_value_unset(&dest_value);
    if(DEBUG)
      g_print("[collect_props_from_gkfile2]%s:\t",keynames[i]);


    // is it really needed ?
    // g_type_init ();

    if(strcmp(keynames[i],"DeviceSize") == 0 || strcmp(keynames[i],"PartitionSize") == 0) {
      g_value_init (&dest_value, G_TYPE_UINT64);
      g_value_set_uint64 (&dest_value, g_key_file_get_integer(gkf, entry,  keynames[i], &error));
    }

    else if(strcmp(keynames[i],"DeviceIsRemovable") == 0 || strcmp(keynames[i],"DeviceIsMounted") == 0) {
      g_value_init (&dest_value, G_TYPE_BOOLEAN);
      g_value_set_boolean (&dest_value, g_key_file_get_boolean(gkf, entry,  keynames[i], &error));
    }
    else if(strcmp(keynames[i],"DeviceMountPaths") == 0 || strcmp(keynames[i],"DeviceFileByPath") == 0 || strcmp(keynames[i],"DeviceFileById") == 0) {
      /*
	//attempt 1:
	g_key_file_set_list_separator(gkf, ',');
	g_param_spec_boxed ("plop", NULL, NULL,
	dbus_g_type_get_collection ("GPtrArray", G_TYPE_STRING),
	G_PARAM_READABLE);
	g_value_init (&dest_value, G_TYPE_BOXED);
      
	g_value_set_boxed (&dest_value,g_key_file_get_string_list(gkf, entry,  keynames[i], &length_collect, &error));
	//g_value_set_boxed (&dest_value, NULL);
	*/

      /*
	// attempt 2:
      g_value_init (&dest_value, G_TYPE_STRING);
      g_value_set_string (&dest_value,g_key_file_get_string(gkf, entry,  keynames[i], &error));
      */

      // attempt 3:
      if(strcmp(keynames[i],"DeviceMountPaths") == 0)
	dp->device_mount_paths = g_key_file_get_string_list(gkf, entry,  keynames[i], &length_collect, &error);
      if(error) {
	if(DEBUG)
	  g_print("%s",error->message);
	g_error_free(error); error = NULL;
      }
      if(strcmp(keynames[i],"DeviceFileByPath") == 0)
	dp->device_file_by_id = g_key_file_get_string_list(gkf, entry,  keynames[i], &length_collect, &error);
      if(error) {
	if(DEBUG)
	  g_print("%s",error->message);
	g_error_free(error); error = NULL;
      }

      if(strcmp(keynames[i],"DeviceFileById") == 0)
	dp->device_file_by_path = g_key_file_get_string_list(gkf, entry,  keynames[i], &length_collect, &error);
      if(error) {
	if(DEBUG)
	  g_print("%s",error->message);
	g_error_free(error); error = NULL;
      }
      
      if(DEBUG) {
	g_print(" ok\n");
      }
      continue;
    }
    else {
      g_value_init (&dest_value, G_TYPE_STRING);
      g_value_set_static_string (&dest_value,g_key_file_get_string(gkf, entry,  keynames[i], &error));
    }

    if(error) {
      if(DEBUG)
	g_print("%s",error->message);
      g_error_free(error); error = NULL;
    }
    
    /* Here we build the DeviceProperties of the current Setting */
    collect_props(keynames[i],
		  &dest_value,
		  dp);
    handled = TRUE;


    if(DEBUG) {
      //g_strdup_value_contents (&dest_value)
      if(g_value_fits_pointer(&dest_value))
	g_print ("%s\n",g_strdup_value_contents (&dest_value));
      else
	g_print(" not defined\n");
    }
    //g_value_unset (&dest_value);
    length_collect = 0;
    error = NULL;
  }
  return handled;
}
