#ifndef ACTION_H
#define ACTION_H

typedef struct {
  int bin_count;
  int script_count;
  gchar **bin;
  gchar *script;
} Action;

Action **actions_init(GKeyFile *gkf, gchar *group);
gboolean is_catchall(Action **catchall_array);
Action *get_catchall(Action **catchall_array, int signal_type);
void exec_action(Action *action);
void action_free(Action *action);
void action_print(Action *action);
void fork_param_substitution(Action *a, DeviceProperties *props);

#endif

