#include <libgen.h>
#include "Action.h"

Action **actions_init(GKeyFile *gkf, gchar *group) {
  int k = 0;
  gchar **bin;
  gchar *script;

  gsize length;
  GError *error = NULL;

  Action **actions;
  // TODO : needed ?
  actions = g_new0(Action *, SIGNAL_COUNT);
  if(!actions) g_warning("ZOB\n");

  gboolean handled = FALSE;

  for( k = 0; sigs[k].signame; k++ ) {
    actions[k] = g_new0(Action, 1);
    g_key_file_set_list_separator(gkf, ' ');
    bin = g_key_file_get_locale_string_list(gkf, group,  sigs[k].signame, "binary", &length, &error);
    if(error) {
      if(DEBUG)
	g_print("[actions_init][%s]error : %s\n", group, error->message);
      g_error_free(error); error = NULL;
    }
    else if(DEBUG)
      g_print("[actions_init][%s][binary]%s : length:%" G_GSIZE_FORMAT "\n", group, sigs[k].signame, length);

    script = g_key_file_get_locale_string(gkf, group,  sigs[k].signame, "script", &error);
    if(error) {
      if(DEBUG)
	g_print("[actions_init][%s][script]error : %s\n", group, error->message);
      g_error_free(error); error = NULL;
    }

    if(!script && !bin) {
      g_print("[actions_init][%s]Can't find neither [script] nor [binary] for %s\n", group, sigs[k].signame);
      // TODO : attempt to find a g_key_file_string[_list] ?
      action_free(actions[k]);
      actions[k] = NULL;
    } else {
      actions[k]->bin = bin;
      actions[k]->script = script;
      handled = TRUE;
    }
  }
  if(handled)
    return actions;
  return NULL;
}


gboolean is_catchall(Action **catchall_array) {
 int i;
  for(i = 0; i<SIGNAL_COUNT; i++)
    if(catchall_array[i]) return TRUE;
  return FALSE;
}

Action *get_catchall(Action **catchall_array, int signal_type) {
  return catchall_array[signal_type];
}

void exec_action(Action *action) {
  pid_t pid;

  if(action->script) {
    char *shellname = getenv("SHELL");
    if(DEBUG)
      g_print("[exec_action]:script: %s\n",action->script);
    (action->script_count)++;
    pid = fork ();
    if (pid > 0)
      g_print("[exec_action]fork\n");
    else if (pid == 0) {
      if(execlp (shellname, basename(shellname), "-c", action->script, NULL) != 0)
	g_warning("[exec_action]script failed !\n");
    } else
      g_warning("[exec_action]cannot fork\n");
    //free(shellname);
    return ;
  }

  if(action->bin) {
    if(DEBUG) {
      g_print("[exec_action]:bin:");
      int i;
      for(i=0;i<MAX_CMDLINE_ARGS;i++) {
	if(action->bin[i])
	  g_print(" %s", action->bin[i]);
	else
	  break;
      }
    }
    g_print("\n");
    (action->bin_count)++;
    pid = fork ();
    if (pid > 0)
      g_print("[exec_action]fork\n");
    else if (pid == 0) {
      if(execvp (action->bin[0], action->bin) != 0)
	g_warning("[exec_action]bin failed !\n");
    } else
      g_warning("[exec_action]cannot fork\n");
  }
}

void action_free(Action *action) {
  if(action) {
    if(DEBUG)
      g_print("[action_free]free bin\n");
    g_strfreev(action->bin);
    if(DEBUG)
      g_print("[action_free]free script\n");
    g_free(action->script);
    if(DEBUG)
      g_print("[action_free]free action\n");
    g_free(action);
  }
  else if(DEBUG)
    g_print("[action_free]Action is NULL\n");
}

void action_print(Action *action) {
  if(!action) {
    if(DEBUG)
      g_print("\taction is NULL\n");
    return;
  }
  g_print("\t\t%d times script: %s\n",action->script_count,action->script);
  g_print("\t\t%d times binary: ",action->bin_count);
  print_str(action->bin);
  g_print("\n");
}

void fork_param_substitution(Action *a, DeviceProperties *props) {
  int i;
  //  GValue dest_value = {0};
  g_print("[fork_param_substitution]starts\n");
  for(i=0;i<MAX_CMDLINE_ARGS;i++) {
    if(!a->bin[i])
      break;

    /*
      for i in native_path device_file id_usage id_type id_version id_uuid id_label partition_uuid partition_label; do
      echo "
      if(strcmp(a->bin[i],\"%$i\") == 0) {
      if(DEBUG)
      g_print(\"[fork_param_substitution]substitution : %s => %s\n\",a->bin[i],props->$i);
      g_stpcpy(a->bin[i],props->$i);
      }";
      done;

      # to much warning with this => not used currently
      for i in device_is_system_internal device_is_removable device_is_media_available device_is_read_only device_is_mounted device_mounted_by_uid partition_table_count partition_number drive_can_detach drive_can_spindown; do
      echo "
      g_type_init ();
      g_value_init (&dest_value, G_TYPE_INT);
      g_value_set_int (&dest_value, props->$i);
      if(strcmp(a->bin[i],\"%$i\") == 0) {
      if(DEBUG)
      g_print(\"[fork_param_substitution]substitution : %s => %s\n\",a->bin[i],g_strdup_value_contents(&dest_value));
      g_stpcpy(a->bin[i],g_strdup_value_contents(&dest_value));
      g_value_unset(&dest_value);
      }";
      done;
     
      for i in device_media_detection_time partition_size; do
      echo "
      g_type_init ();
      g_value_init (&dest_value, G_TYPE_UINT64);
      g_value_set_uint64 (&dest_value, props->$i);
      if(strcmp(a->bin[i],\"%$i\") == 0) {
      if(DEBUG)
      g_print(\"[fork_param_substitution]substitution : %s => %s\n\",a->bin[i],g_strdup_value_contents(&dest_value));
      g_stpcpy(a->bin[i],g_strdup_value_contents(&dest_value));
      g_value_unset(&dest_value);
      }";
      done;
    */
    if(strcmp(a->bin[i],"%device_mount_paths") == 0) {
      if(DEBUG) {
	g_print("[fork_param_substitution]substitution : %s => ",a->bin[i]);
	print_str(props->device_mount_paths);
	g_print("\n");
      }
      g_stpcpy(a->bin[i],g_strjoinv (",",props->device_mount_paths));
    }
    


    /* generated content follows */

    if(strcmp(a->bin[i],"%native_path") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->native_path);
      g_stpcpy(a->bin[i],props->native_path);
    }

    if(strcmp(a->bin[i],"%device_file") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->device_file);
      g_stpcpy(a->bin[i],props->device_file);
    }

    if(strcmp(a->bin[i],"%id_usage") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->id_usage);
      g_stpcpy(a->bin[i],props->id_usage);
    }

    if(strcmp(a->bin[i],"%id_type") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->id_type);
      g_stpcpy(a->bin[i],props->id_type);
    }

    if(strcmp(a->bin[i],"%id_version") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->id_version);
      g_stpcpy(a->bin[i],props->id_version);
    }

    if(strcmp(a->bin[i],"%id_uuid") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->id_uuid);
      g_stpcpy(a->bin[i],props->id_uuid);
    }

    if(strcmp(a->bin[i],"%id_label") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->id_label);
      g_stpcpy(a->bin[i],props->id_label);
    }

    if(strcmp(a->bin[i],"%partition_uuid") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->partition_uuid);
      g_stpcpy(a->bin[i],props->partition_uuid);
    }

    if(strcmp(a->bin[i],"%partition_label") == 0) {
      if(DEBUG)
	g_print("[fork_param_substitution]substitution : %s => %s\n",a->bin[i],props->partition_label);
      g_stpcpy(a->bin[i],props->partition_label);
    }

  }
}

