typedef struct {
  gchar  *event_name;
  // number of times the event happens
  // useless right now
  int happened;
  gchar **to_exec;
  gchar **to_exec_script;
  /* TODO :
     let's use %
     - mount_point
     - device_...
     (like udev)
   */
} Signal;

typedef struct {
  // a DeviceProperties
  DeviceProperties *dp;
  gchar nickname[50];
  // {un,}mount,added,removed
  Signal *signal[SIGNAL_COUNT];
} Setting;

void settings_init(gchar *filename, Setting **settings);
void  signal_free(Signal **signal);
void setting_free(Setting *s);
void show_signal_info(Signal *s);
void show_signals_info(Signal **ss);
void setting_show_info(Setting *a);
gboolean is_one_setting_match_on_event(Setting **a, gchar *evt);
Signal *setting_match_on_event(Setting *a, gchar *evt);
void setting_inc_happened(Setting *a, gchar *evt);
void collect_props_from_gkfile2(DeviceProperties *dp, GKeyFile *gkf, gchar *entry);
//void set_mount_paths(DeviceProperties *dp,gchar *tmpstr);

void settings_init(gchar *filename, Setting **settings){
  GKeyFile *keyfile;
  GKeyFileFlags flags;
  GError *error = NULL;
  gsize length;
  gchar **groups;
  gchar *asig;
  int i = 0, j = 0, k;
  
  /* Create a new GKeyFile object and a bitwise list of flags. */
  keyfile = g_key_file_new ();
  flags = G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS;
  
  /* Load the GKeyFile from keyfile.conf or return. */
  if (!g_key_file_load_from_file (keyfile, filename, flags, &error)) {
    g_warning (">[settings_init]%s",error->message);
    return ;
  }
  if(DEBUG)
    g_print(">[settings_init]opening %s : ok\n",filename);

  groups = g_key_file_get_groups (keyfile, &length);
  while (groups[i] != NULL && j<MAX_SETTINGS) {
    if(DEBUG)
      g_print(">[settings_init]loading group [%s]\n",groups[i]);
    
    if(settings[j] != NULL) {
      j++;
      if(j >= MAX_SETTINGS) {
	g_warning("Cannot store more settings\n");
	return;
      }
      continue;
    }
    settings[j] = g_new0(Setting,1);
    settings[j]->dp = g_new0(DeviceProperties, 1);
    g_stpcpy(settings[j]->nickname,groups[i]);
    for(k=0;k<SIGNAL_COUNT;k++) {
      asig=signalnames[k];
      settings[j]->signal[k] = g_new0(Signal, 1);
      settings[j]->signal[k]->happened = 0;
      settings[j]->signal[k]->event_name = asig;
      // solution 1 but : can't load in a gchar ** !?
      /*settings[j]->signal[k]->to_exec = g_key_file_get_string_list(keyfile, groups[i],  asig, &length, &error);
      g_print("LENGTH = %d !!!!!!!!!!!!!",length);
      if(settings[j]->signal[k]->to_exec == NULL || length == 0) {
	if(DEBUG)
	  g_print("%s\n",error->message);
	settings[j]->signal[k] = NULL;
	}*/

      /** solution 2 */
      settings[j]->signal[k]->to_exec = g_strsplit(g_key_file_get_string(keyfile, groups[i],  asig, &error),
						   " ",
						   MAX_CMDLINE_ARGS);
      if(error != NULL) {
	g_print("%s\n",error->message);
	settings[j]->signal[k] = NULL;
      }
      /* end solution 2 */

      error = NULL;
    }
      
    if(DEBUG)
      g_print(">[settings_init]collect_props %s: ",filename);
    collect_props_from_gkfile2(settings[j]->dp,keyfile,groups[i]);
    if(DEBUG)
      g_print(">[settings_init]end collect\n");

    if(settings[j]->nickname == NULL) {
      g_warning(">[settings_init]no nickname key found\n");
      i++;
      continue;
    }
    if(settings[j]->signal == NULL) {
      g_warning(">[settings_init]no signal key found\n");
      i++;
      continue;
    }

    /* TO(UN)DO :
       if we get both something to do at plug time AND mount time,
       we skip the plug time event as it will make mount change event
       not being fired
     */
    /*
      Signal *tmpsig;
      
      if((tmpsig = setting_match_on_event(settings[j],"DeviceAdded")) &&
      setting_match_on_event(settings[j],"DeviceMounted")) {
      tmpsig = NULL;
      }
    */

    g_print(">[settings_init]loaded [%s]\n",settings[j]->nickname);

    j++;
    i++;
  }
  g_strfreev(groups);
  g_key_file_free(keyfile);

  if (j==1) {
    return ;
    //return NULL;
  }
  // add trailing NULL
  while(j < MAX_SETTINGS)
    settings[j++] = NULL;


  //return settings;
}

void  signal_free(Signal **signal) {
  int i;
  if(signal == NULL) 
    g_print("[signal]Cant free NULL signal\n");
  for(i = 0;i<SIGNAL_COUNT;i++) {
    if(signal[i] != NULL) {
      /*g_print("[signal]free event_name\n");
	g_free(signal[i]->event_name);*/
      g_print("[signal]free to_exec\n");
      g_strfreev(signal[i]->to_exec);
      g_free(signal[i]);
    }
  }
}
      
void setting_free(Setting *s) {
  g_print("== Freeing Setting\n");
  g_print("===== Freeing DeviceProperties\n");
  device_properties_free(s->dp);
  g_print("===== Freeing Signals\n");
  signal_free(s->signal);
  /* g_print("free nick\n");
     g_free(s->nickname);*/
  g_print("===== Freeing Setting\n");
  g_free(s);
}

void show_signal_info(Signal *s) {
  if(s != NULL) {
    g_print("[%s]: ",s->event_name);
    g_print("%s\t\t",s->to_exec[0]);
    g_print("(%d times)\n",s->happened);
  }
}
void  show_signals_info(Signal **ss) {
  int i;
  if(ss == NULL) {
    g_print("no signal\n");
    return;
  }
  for(i = 0;i<SIGNAL_COUNT;i++)
    show_signal_info(ss[i]);
}
void setting_show_info(Setting *a) {
  if(a != NULL) {
    g_print("=====SHOW INFO :\n");
    g_print("Setting : %s\n",a->nickname);
    show_signals_info(a->signal);
    do_show_info_device_property(a->dp);
    g_print("================\n");
  } else if(DEBUG)
    g_print("NULL setting\n");
}

void settings_show_info(Setting **a) {
  int i;
  if(a != NULL) {
    for(i=0;i<MAX_SETTINGS;i++)
      setting_show_info(a[i]);
  } else
    g_print("NULL settings\n");
  g_print("================\n");
}
// does one of the Setting in settings is triggered by the event evt
gboolean is_one_setting_match_on_event(Setting **a, gchar *evt) {
  //g_print("[is_one_setting_match_on_event] %s\n",evt);
  Signal *sigtmp;
  int i;
  for(i=0;i<MAX_SETTINGS && a[i] != NULL;i++) {
    sigtmp=setting_match_on_event(a[i],evt);
    if (sigtmp != NULL)
      return TRUE;
  }
  return FALSE;
}

// does the given Setting is triggered by the event evt
Signal *setting_match_on_event(Setting *a, gchar *evt) {
  int j;
  Signal *tmpsig;
  for(j=0;j<SIGNAL_COUNT;j++) {
    tmpsig=a->signal[j];
    if(tmpsig != NULL && strcmp(tmpsig->event_name,evt) == 0) {
      return tmpsig;
    }
  }
  return NULL;
}

void setting_inc_happened(Setting *a, gchar *evt) {
  int j;
  if(a == NULL || a->signal == NULL) return ;
  for(j=0;j<SIGNAL_COUNT;j++)
    if(a->signal[j] != NULL && strcmp(a->signal[j]->event_name,evt) == 0) {
      (a->signal[j]->happened)++;
      return ;
    }
}

/* Parse a file in the "Desktop Entry" */
void collect_props_from_gkfile2(DeviceProperties *dp, GKeyFile *gkf, gchar *entry) {
  GError *error_collect = NULL;
  int i = 0;
  GValue dest_value = {0};
  gchar *tmpstr;

  if(dp == NULL) {
    g_warning (">>collect_props_from_gkfile2%s\n",error_collect->message);
  }
  if(DEBUG)
    g_print("ok\n");

  // some defaults:
  /* 1 */
  g_type_init ();
  g_value_init (&dest_value, G_TYPE_BOOLEAN);
  g_value_set_boolean (&dest_value, TRUE);
  collect_props("DeviceIsDrive", &dest_value, dp);
  g_value_unset(&dest_value);
  /* 2 : bugs otherwise */
  dp->device_file_by_id = NULL;
  /* 3 : needs props->drive_media_compatibility != NULL && */
  dp->drive_media_compatibility = NULL;

  // foreach the   "DeviceFile*", "DeviceIs*",  "DeviceMountPaths",  "DeviceSize",  ... id, label , vendor, model
  for (i=0; i<PROP_COUNT; i++) {
    if(DEBUG)
      g_print(">>[collect_props_from_gkfile2]%s:\t",keynames[i]);
    tmpstr = g_key_file_get_string(gkf, entry,  keynames[i], &error_collect);
    //g_print(" (VALUE=%s) ",tmpstr);

    if(tmpstr != NULL) {
      g_type_init ();

      if(strcmp(keynames[i],"DeviceIsRemovable") == 0 || strcmp(keynames[i],"DeviceIsMounted") == 0) {
	g_value_init (&dest_value, G_TYPE_BOOLEAN);
	if(strcmp(tmpstr,"1") || strcmp(tmpstr,"TRUE"))
	  g_value_set_boolean (&dest_value, FALSE);
	else
	  g_value_set_boolean (&dest_value, TRUE);
      }
      else if(strcmp(keynames[i],"DeviceMountPaths") == 0) {
	dp->device_mount_paths = g_strsplit(tmpstr,", ",5);
	g_free(tmpstr);  
	if(DEBUG)
	  g_print(" %s\n",tmpstr);
	continue;
	/* other solution :
	  g_value_init (&dest_value, G_TYPE_BOXED);
	  g_value_set_boxed (&dest_value,tmpstr);*/
      }
      else {
	g_value_init (&dest_value, G_TYPE_STRING);
	g_value_set_static_string (&dest_value,tmpstr);
      }
      //g_print ("[GValue content:%s]",g_strdup_value_contents (&dest_value));

      /* Here we build the DeviceProperties of the current Setting */
      collect_props(keynames[i],
		    &dest_value,
		    dp);

      g_value_unset (&dest_value);
      if(DEBUG)
	g_print(" %s\n",tmpstr);
    }
    else 
      if(DEBUG)
	g_print(" not defined\n");
    error_collect = NULL;
    g_free(tmpstr);
  }
}

