//gcc -Wall -ggdb -I/usr/include/dbus-1.0 -I/usr/include/glib-2.0 -I/usr/lib64/glib-2.0/include -ldbus-glib-1 dkd.c -o dkd dkd.c

/*
  README
  this programs will monitor dbus DeviceKit-Disks events
  and match them against the configuration file(s) given as argument.

  If an event which was registered in those files happens
  AND
  if both DeviceProperties (partialy) match
  THEN the value of the "exec" key is ... printed

  attempt for the record of the bloatest code
 */
#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdio.h>
#include <glib.h>
#include <dbus/dbus-glib.h>
#include <glib/gstdio.h>

/* replace with the correct location */
#include "DeviceKit-disks/src/devkit-disks-marshal.c"
/* I cant include that properly */
//#include "DeviceKit-disks/tools/devkit-disks.c"
#include "dkd.h"
void collect_props_from_gkfile(DeviceProperties *dp, GKeyFile *gkf);
#include "Setting.c"

#define MAX_SETTINGS 15
#define DEBUG FALSE

static  Setting *settings[MAX_SETTINGS];
static DBusGConnection     *bus = NULL;
static DBusGProxy          *disks_proxy = NULL;
static GMainLoop           *loop;

static void device_common_signal_handler(gchar *event, const gchar *object_path);
static void device_added_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data);
static void device_removed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data);
static void device_job_changed_signal_handler (DBusGProxy *proxy,
					       const char *object_path,
					       gboolean    job_in_progress,
					       const char *job_id,
					       guint32     job_initiated_by_uid,
					       gboolean    job_is_cancellable,
					       double      job_percentage,
					       gpointer    user_data);
static void device_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data);

void do_monitor (void);

void do_monitor (void) {
  GError *error;

  g_print ("Monitoring activity from the disks daemon. Press Ctrl+C to cancel.\n");

  error = NULL;

  /*
    attach to event only if one of the Settings looks for it
   */
  if(is_one_setting_match_on_event(settings, "DeviceAdded"))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceAdded",
				 G_CALLBACK (device_added_signal_handler), NULL, NULL);

  if(is_one_setting_match_on_event(settings, "DeviceRemoved"))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceRemoved",
				 G_CALLBACK (device_removed_signal_handler), NULL, NULL);

  if(is_one_setting_match_on_event(settings, "DeviceUnmounted") || 
     is_one_setting_match_on_event(settings, "DeviceChanged"))
    dbus_g_proxy_connect_signal (disks_proxy, "DeviceChanged",
				 G_CALLBACK (device_changed_signal_handler), NULL, NULL);

  dbus_g_proxy_connect_signal (disks_proxy, "DeviceJobChanged",
			       G_CALLBACK (device_job_changed_signal_handler), NULL, NULL);

  g_print("main loop\n");
  g_main_loop_run (loop);
}

gboolean init() {
  GError              *error = NULL;
  GOptionContext      *context;
  g_type_init ();
  context = g_option_context_new ("DeviceKit-disks tool");
  g_option_context_set_description (context, "See the devkit-disks man page for details.");
  //g_option_context_add_main_entries (context, entries, NULL);

  loop = g_main_loop_new (NULL, FALSE);
  bus = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
  if (bus == NULL) {
    g_warning ("Couldn't connect to system bus: %s", error->message);
    g_error_free (error);
    return FALSE;
  }
  dbus_g_object_register_marshaller (
				     devkit_disks_marshal_VOID__BOXED_BOOLEAN_STRING_UINT_BOOLEAN_DOUBLE,
				     G_TYPE_NONE,
				     DBUS_TYPE_G_OBJECT_PATH,
				     G_TYPE_BOOLEAN,
				     G_TYPE_STRING,
				     G_TYPE_UINT,
				     G_TYPE_BOOLEAN,
				     G_TYPE_DOUBLE,
				     G_TYPE_INVALID);

  disks_proxy = dbus_g_proxy_new_for_name (bus,
					   "org.freedesktop.DeviceKit.Disks",
					   "/org/freedesktop/DeviceKit/Disks",
					   "org.freedesktop.DeviceKit.Disks");
  if(is_one_setting_match_on_event(settings, "DeviceAdded"))
    dbus_g_proxy_add_signal (disks_proxy, "DeviceAdded", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);
  if(is_one_setting_match_on_event(settings, "DeviceRemoved"))
    dbus_g_proxy_add_signal (disks_proxy, "DeviceRemoved", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);

  dbus_g_proxy_add_signal (disks_proxy, "DeviceChanged", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_INVALID);
  dbus_g_proxy_add_signal (disks_proxy, "DeviceJobChanged", DBUS_TYPE_G_OBJECT_PATH, G_TYPE_BOOLEAN,
			   G_TYPE_STRING,
			   G_TYPE_UINT,
			   G_TYPE_BOOLEAN,
			   G_TYPE_DOUBLE,
			   G_TYPE_INVALID);
  return TRUE;
}

/*
  List all settings then :
  1) look if the event type (removed, mounted, ...) match the Setting->event field
  2) look if the characteristics of the device match the Setting->DeviceProperties struct
  [3) special case for devices removed]
  4) print (should be execve) the Setting->to_exec
 */
static void device_common_signal_handler(gchar *event, const gchar *object_path) {
  DeviceProperties *props;
  int i;
  if(strcmp(event, "DeviceRemoved") != 0)
     props = device_properties_get(bus, object_path);

  if(DEBUG) {
    g_print("[device_common_signal_handler]EVENT = %s\n",event);
    if(strcmp(event, "DeviceRemoved") != 0)
       do_show_info_device_property (props);
  }

  for (i=0;i<MAX_SETTINGS && settings[i] != NULL;i++) {
    if(DEBUG)
      g_print("[device_common_signal_handler]test event<->setting (%s)\n",settings[i]->nickname);
    if(!setting_match_on_event(settings[i], event))
      continue;
    if(DEBUG) {
      g_print("[device_common_signal_handler]\t\tMATCHED\n");
      g_print("[device_common_signal_handler]\ttest props<->setting\n");
    }
    if(strcmp(event, "DeviceRemoved") != 0 && !prop_cmp(settings[i]->dp,props))
      continue;
    /* TODO :  do some stuff with native_path and object_path
	 in the case we removed a device
    */
    if(DEBUG)
      g_print("[device_common_signal_handler]\t\tMATCHED (happened %d)\n",settings[i]->happened);

    (settings[i]->happened)++;
    if(DEBUG) {
      g_print("SETTINGS MATCHING >>>>>>>>\n");
      setting_show_info(settings[i]);
    }
    g_print("[%s]\t%s\n",settings[i]->nickname,settings[i]->to_exec[0]);
    if(DEBUG)
      g_print("<<<<<<<<<<<<<<<<<<<<<<<<\n");
  }
  g_print("====================\n");

  if(!strcmp(event, "DeviceRemoved"))
    g_free(props);
}

static void device_added_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  g_print ("added:     %s\n", object_path);
  device_common_signal_handler("DeviceAdded", object_path);
}
static void device_removed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  g_print ("removed:   %s\n", object_path);
  device_common_signal_handler("DeviceRemoved", object_path);
}

/*
  a bit specific to match the case where the user wants only to react to [un]mount
  so, the, eg, DeviceMounted event value is matched when both :
  - DeviceChanged is caught
  AND
  - DeviceIsMounted == 0
  happens
  
 */
static void device_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gpointer user_data) {
  DeviceProperties *props; 
  g_print ("changed:     %s\n", object_path);

  // currently exclusive priority, good choice ?
  if (is_one_setting_match_on_event(settings, "DeviceChanged")) {
    device_common_signal_handler("DeviceChanged", object_path);
  }
  else {
    if(DEBUG)
      g_print("MATCH Device[Un]mounted\n");
    props = device_properties_get(bus, object_path);
    /* TODO : to much trigger */
    // at least one Setting needs to be treated : unmount (and a device is currently not mounted and has just changed)
    if(!props->device_is_mounted && is_one_setting_match_on_event(settings, "DeviceUnmounted"))
      device_common_signal_handler("DeviceUnmounted", object_path);
    // at least one Setting needs to be treated : mount (and a device is currently mounted and has just changed)
    if(props->device_is_mounted && is_one_setting_match_on_event(settings, "DeviceMounted"))
      device_common_signal_handler("DeviceMounted", object_path);
    g_free(props);
  }
}

// TODO
static void device_job_changed_signal_handler (DBusGProxy *proxy, const char *object_path, gboolean    job_in_progress,
					       const char *job_id, guint32     job_initiated_by_uid, gboolean    job_is_cancellable,
					       double      job_percentage, gpointer    user_data) {
  g_print ("job-changed: %s\n", object_path);
  /*if (opt_monitor_detail) {
    print_job (job_in_progress,
    job_id,
    job_initiated_by_uid,
    job_is_cancellable,
    job_percentage);
    }*/
}

/* Parse a file in the "Desktop Entry" spec */
void collect_props_from_gkfile(DeviceProperties *dp, GKeyFile *gkf) {
  GError *error_collect = NULL;
  int i = 0;
  GValue dest_value = {0};
  gchar *tmpstr;

  if(dp == NULL) {
    g_warning ("%s\n",error_collect->message);
  }
  if(DEBUG)
    g_print("ok\n");

  // some defaults:
  /* 1 */
  g_type_init ();
  g_value_init (&dest_value, G_TYPE_BOOLEAN);
  g_value_set_boolean (&dest_value, TRUE);
  collect_props("DeviceIsDrive", &dest_value, dp);
  g_value_unset(&dest_value);
  /* 2 : bugs otherwise */
  dp->device_file_by_id = NULL;
  /* 3 : needs props->drive_media_compatibility != NULL && */
  dp->drive_media_compatibility = NULL;

  // foreach the   "DeviceFile*", "DeviceIs*",  "DeviceMountPaths",  "DeviceSize",  ... id, label , vendor, model
  for (i=0; i<PROP_COUNT; i++) {
    if(DEBUG)
      g_print("\tcollecting props %s:\t",keynames[i]);
    tmpstr = g_key_file_get_string(gkf, "spec",  keynames[i], &error_collect);
    //g_print(" (VALUE=%s) ",tmpstr);

    if(tmpstr != NULL) {
      g_type_init ();
      /*      if(strcmp(keynames[i],"DeviceIsRemovable") == 0)
	      g_value_init (&dest_value, G_TYPE_STRING);
	      else if(strcmp(keynames[i],"DeviceMountPaths") == 0)
	      g_value_init (&dest_value, G_TYPE_BOXED);
	      else*/
      g_value_init (&dest_value, G_TYPE_STRING);
      g_value_set_static_string (&dest_value,tmpstr);

      //g_print ("[GValue content:%s]",g_strdup_value_contents (&dest_value));

      /* Here we build the DeviceProperties of the current Setting */
      collect_props(keynames[i],
		    &dest_value,
		    dp);

      g_value_unset (&dest_value);
      if(DEBUG)
	g_print(" %s\n",tmpstr);
    }
    else 
      if(DEBUG)
	g_print(" not defined\n");
    error_collect = NULL;
    g_free(tmpstr);
  }
}

int main (int argc, char **argv) {
  //Setting *settings[MAX_SETTINGS];
  GError *error = NULL;
  const gchar *filename;
  gchar *fullpath;
  GDir *dir;
  int i = 0;

  if(argc==2) {
    if(DEBUG)
      g_print("opening %s\n",argv[1]);
  }
  else {
    g_print("Usage: %s <FILE|DIRECTORY>\n",argv[0]);
    return 1;
  }

  /* arg is a file */
  i=1;
  if (g_file_test (argv[1], G_FILE_TEST_IS_REGULAR)) {
    settings[0] = g_new0 (Setting, 1);
    settings[0]->dp = g_new0 (DeviceProperties, 1);
    
    // load into settings[0]
    if (setting_init(argv[1],settings[0])) {
      if(DEBUG)
	g_print("loaded %s\n", argv[1]);
    }
  }
  /* arg is a dir, load all subfiles */
  else if (g_file_test (argv[1], G_FILE_TEST_IS_DIR)) {
    dir = g_dir_open(argv[1],0,&error);
    if (error) {
      g_printerr ("g_dir_open(%s) failed - %s\n", argv[1], error->message);
      g_error_free(error);
      return -1;
    }

    i = 0;
    while((filename = g_dir_read_name(dir)) && i<MAX_SETTINGS) {
      if(DEBUG)
	g_print("proceed %s\n",filename);
      settings[i] = g_new0(Setting,1);
      settings[i]->dp = g_new0(DeviceProperties, 1);

      if (g_path_is_absolute (filename))
	fullpath = g_strdup (filename);
      else
	fullpath = g_build_filename (argv[1], filename, NULL);

      if (g_file_test (fullpath, G_FILE_TEST_IS_REGULAR)) {
	// load into Settings ** settings
	if (setting_init(fullpath,settings[i])) {
	  if(DEBUG)
	    g_print("loaded %s\n", fullpath);
	}
      }
      
      g_free(fullpath);
      i++;
    }
    g_dir_close(dir);
  }
  else
    g_error("Cannot stat %s\n",argv[1 ]);

  // add trailing NULL
  while(i < MAX_SETTINGS)
    settings[i++] = NULL;

  /*
    // show all loaded Settings
    for (i=0;i<MAX_SETTINGS;i++)
    if(settings[i] != NULL)
    setting_show_info(settings[i]);
  */

  /*
    // test the setting comparator function
    int j;
    for (i=0;i<MAX_SETTINGS;i++)
    if(settings[i] != NULL)
    for (j=0;j<MAX_SETTINGS;j++)
    if(settings[j] != NULL) {
    g_print("COMPARE : %s <-> %s : ",settings[i]->nickname,settings[j]->nickname);
    if (prop_cmp(settings[i]->dp,settings[j]->dp))
    g_print(" ==\n");
    else
    g_print(" !=\n");
    }
  */



  if (init()) {
    do_monitor ();
  }




  for (i=0;i<MAX_SETTINGS;i++)
    if(settings[i] != NULL)
      setting_free(settings[i]);

  if (disks_proxy != NULL)
    g_object_unref (disks_proxy);
  if (bus != NULL)
    dbus_g_connection_unref (bus);
  return 0;
}
