#define MAX_SETTINGS 15
// should also be set in dkd.c
#define DEBUG FALSE

typedef struct
{
  // a DeviceProperties
  DeviceProperties *dp;
  gchar *nickname, *event;
  // number of times the event happens
  int happened;
  gchar **to_exec;
} Setting;

// http://www.gtkbook.com/tutorial.php?page=keyfile
gboolean setting_init(gchar *filename, Setting *conf) {
  GKeyFile *keyfile;
  GKeyFileFlags flags;
  GError *error = NULL;
  gsize length;
  /*
    // future use
    gchar ** groups;
    int i;
  */

  if(DEBUG)
    g_print("opening %s: ",filename);
  /* Create a new GKeyFile object and a bitwise list of flags. */
  keyfile = g_key_file_new ();
  flags = G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS;
  
  /* Load the GKeyFile from keyfile.conf or return. */
  if (!g_key_file_load_from_file (keyfile, filename, flags, &error)) {
    g_warning ("%s",error->message);
    return FALSE;
  }
  if(DEBUG)
    g_print("ok\n");

  /* TODO !!
  groups = g_key_file_get_groups (keyfile, length);
  while (groups[i] != NULL) { ...}
  // but imply change the 2nd args to Setting **
  */
  conf->nickname = g_key_file_get_string (keyfile, "spec",  "name", &error);
  // TODO : select
  // TODO 2 : grab mount events
  conf->event = g_key_file_get_string (keyfile, "spec",  "event", &error);
  conf->to_exec = g_key_file_get_string_list (keyfile, "spec",  "exec", &length, &error);

  if(conf->event == NULL) {
    g_warning("no event key found\n");
    return FALSE;
  }
  if(conf->to_exec == NULL) {
    g_warning("no exec key found\n");
    return FALSE;
  }
  conf->happened = 0;
  //conf->dp = g_new0 (DeviceProperties, 1);

  if(DEBUG)
    g_print("collect_props %s: ",filename);
  collect_props_from_gkfile(conf->dp,keyfile);
  g_key_file_free(keyfile);
  /* TODO :
     check at least 1 exec, 1 event, 1 props elem
     then return TRUE
  */
  
  //do_show_setting_info(conf);

  return TRUE;
}

static void setting_free(Setting *s) {
  g_free(s->nickname);
  g_free(s->event);
  g_free(s->to_exec);
  device_properties_free(s->dp);
  g_free(s);
}

void setting_show_info(Setting *a) {
  g_print("Setting : %s\n",a->nickname);
  g_print("\tused %d times\n",a->happened);
  g_print("\ton event : %s\n",a->event);
  g_print("\tdo: %s\n",a->to_exec[0]);
  do_show_info_device_property(a->dp);
}

// does one of the Setting in settings is triggered by the event evt
gboolean is_one_setting_match_on_event(Setting **a, gchar *evt) {
  //g_print("[is_one_setting_match_on_event] %s\n",evt);
  int i;
  for(i=0;i<MAX_SETTINGS && a[i] != NULL;i++) {
    //g_print("   %d : %s\n",i,a[i]->event);
    if(strcmp(a[i]->event,evt) == 0)
      return TRUE;
  }
  return FALSE;
}

/* // no more used
static Setting ** settings_match_on_event(Setting **a, gchar *evt) {
  if(DEBUG)
    g_print("[settings_match_on_event] -%s-\n",evt);
  static Setting *new_settings[MAX_SETTINGS];
  int i, j=0;
  for(i=0;i<MAX_SETTINGS  && a[i] != NULL; i++) {
    if(DEBUG)
      g_print("[settings_match_on_event]\ttest elem[%d] = %s\t(%s)\n",i,a[i]->nickname,a[i]->event);
    if(strcmp(a[i]->event,evt) == 0) {
      if(DEBUG)
	g_print("[settings_match_on_event]\t\tMATCHED\n");
      new_settings[j] = g_new0 (Setting, 1);
      new_settings[j] = a[i];
      j++;
    }
  }
  if (j==0) return NULL;
  return new_settings;
  } */

// does the given Setting is triggered by the event evt
gboolean setting_match_on_event(Setting *a, gchar *evt) {
  if(DEBUG)
    g_print("\t[settings_match_on_event]%s\t(%s) for event %s\n",a->nickname,a->event, evt);
  if(a != NULL && strcmp(a->event,evt) == 0) {
      if(DEBUG)
	g_print("\t[settings_match_on_event]\t\tMATCHED\n");
      return TRUE;
  }
  return FALSE;
}
