#!/usr/bin/gawk -f

BEGIN {
 fs = ( fs == "" ) ? " " : fs
 if ( c == "" ) c = ENVIRON["COLUMNS"] ? ENVIRON["COLUMNS"] : 64
 ll = length( fs )
}

{
 if ( /\/$/ ) send( "dir" )
 else if ( /'$/ || ! /[@=|*>]$/ ) send( "file" )
 else send( "special" )
}

function send( t   ,l ) {
 if ( t in skip ) return
 l = length()
 if ( ( len[t] += l ) > c ) skip[t]
 if ( ! ( t in skip ) ) res[t] = res[t] $0
 if ( ( len[t] += ll ) >= c ) skip[t]
 if ( ! ( t in skip ) ) res[t] = res[t] fs
}

END {
 printf "%s\n%s\n%s\n", res["dir"], res["file"], res["special"]
}