#!/usr/bin/gawk -f

BEGIN {
 RS = "\0"
 FS = "/+"
 ORS = "\n\n"
 OFS = " "

 getline name
 getline base
 gsub( /./, "[&]", base )

 e = split( "eval1 set shopt declare alias function override keyword eval2", sup, " " )
 while ( ++i <= e ) supported[sup[i]]

 set__["on"] = "-"
 set__["off"] = "+"
}

{
 file[++_file] = $0
}

function cat( f  ,r,t ) {
 while ( getline t <f ) r = r t RT
 close( f )
 return r
}

function q( s, ss ) {
 gsub( "'", "'\\''", s )
 if ( ss ) return "'" s "'"
 else return s
}

function override_(   which,kw,kk,kkk,n ) {
 if ( $1 != "keyword" ) return
 sub( "[^/]+/", "" )
 which = $1
 sub( "[^/]+/", "" )
 kw = $0
 if ( which == "kws" ) {
  split( a["c"] , kkk , "\0" )
  while ( ++n in kkk ) kk = kk q( kkk[n], 1 ) " "
  a["c"] = kk
 } else if ( which == "code" ) k[kw] = a["c"]
 o[kw, which] = a["c"]
}

function keyword_() {
 s["kw"]++
 k[$0] = a["c"]
}

function declare_( t,v,e ) {
 if ( $1 ~ "^-" ) { t = $1 ; sub( "[^/]+/", "" ); ++_dec }
 if ( NF > 1 ) {
  e = gensub( "[^/]+/(.*)", "\\1", 1 )
  if ( t ) dec_[t, ++dec__[t]] = $1 "[" q( e, 1 ) "]=" q( a["c"], 1 )
  else dec = dec $1 "[" ( (e ~ /^[0-9]+$/) ? q( e, 0 ) : q( e, 1 ) ) "]=" q( a["c"], 1 ) " "
 } else if ( t )
  dec_[t, ++dec__[t]] = $1 "=" q( a["c"], 1 ) ""
 else
  dec = dec $1 "=" q( a["c"], 1 ) " "
}

function eval1_() {
 res = res a["c"] ORS
}

function eval2_() {
 eval2 = eval2 a["c"] ORS
}

function function_() {
 func_ = func_ a["t"] "() { " a["c"] "\n}" ORS
}

function alias_() {
 al = al a["t"] "=" q( a["c"], 1 )  " "
}

function set_() {
 $0 = a["t"]
 if ( $1 in set__ ) _set = _set set__[$1] $2 " "
}

function shopt_() {
 $0 = a["t"]
 if ( $1 == "on" ) shopt_on = shopt_on $2 " "
 else if ( $1 == "off" ) shopt_off = shopt_off $2 " "
}

END { i = 0
 while ( ++i <= _file ) {
  if ( ( file[i] "/" ) in dir ) continue
  $0 = origfile = file[i]
  if ( ! sub( "^" base "/", "" ) ) continue
  if ( ! ( $1 in supported ) ) continue
  E = $1 "_"
  sub( "[^/]+/", "" )
  a["t"] = $0
  a["c"] = cat( origfile )

  @E()
 }

 if ( _set != "" ) res = res "set " _set ORS
 if ( shopt_on ) res = res "shopt -s " shopt_on ORS
 if ( shopt_off ) res = res "shopt -u " shopt_off ORS
 if ( _dec ) {
  for ( r in dec__ ) {
   res = res "declare " r " "
   i = 0 ; while ( ++i <= dec__[r] ) res = res dec_[r, i] " "
   res = res ORS
  }
 }
 if ( dec != "" ) res = res dec ORS
 if ( al != "" ) res = res "alias -- " al ORS
 if ( func_ != "" ) res = res func_
 if ( s["kw"] > 0 ) {
  for (kw in k) {
   if ( ( ( t=kwSUBSEP"kwns") in o ) ) kws = kws "kwns=" q( o[t], 1 ) " "
   kws = kws "takes=" q( o[kw,"takes"], 1 ) " "
   kws = kws "code=" q( ( (t=kw SUBSEP"code") in o ) ? o[t] : k[kw] , 1 ) " "
   kws = kws "+kw " ( ( ( t=kw SUBSEP "kws" ) in o ) ? o[t] : q( kw, 1 ) )
   kws = kws ORS
  }
  res = res kws
 }
 if ( xblm != "" ) res = res xblm ORS
 if ( eval2 != "" ) res = res eval2 ORS

 if ( res != "" ) { printf "%s", res; fflush() }
 exit(0)
}
